/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.conflation.ConflationCandidate;
import org.openstreetmap.josm.plugins.conflation.ConflationCandidateList;
import org.openstreetmap.josm.plugins.conflation.ConflationLayer;
import org.openstreetmap.josm.plugins.conflation.ConflationListChangedListener;
import org.openstreetmap.josm.plugins.conflation.ConflationPlugin;
import org.openstreetmap.josm.plugins.conflation.ConflationUtils;
import org.openstreetmap.josm.plugins.conflation.MatchTableModel;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.HungarianAlgorithm;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflationToggleDialog
extends ToggleDialog
implements MapView.EditLayerChangeListener,
SelectionChangedListener,
DataSetListener,
ConflationListChangedListener {
    public static final String PREF_PREFIX = "conflation";
    JTable resultsTable;
    ConflationLayer conflationLayer;
    MatchTableModel tableModel;
    ConflationCandidateList candidates = new ConflationCandidateList();
    ConflationOptionsDialog optionsDialog = new ConflationOptionsDialog();

    public ConflationToggleDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, ConflationPlugin conflationPlugin) {
        super(I18n.tr((String)name, (Object[])new Object[0]), iconName, I18n.tr((String)tooltip, (Object[])new Object[0]), shortcut, preferredHeight);
        this.optionsDialog.setModalityType(Dialog.ModalityType.MODELESS);
        this.tableModel = new MatchTableModel();
        this.tableModel.setCandidates(this.candidates);
        this.candidates.addConflationListChangedListener(this.tableModel);
        this.resultsTable = new JTable(this.tableModel);
        this.resultsTable.getSelectionModel().addListSelectionListener(new MatchListSelectionHandler());
        this.resultsTable.getColumnModel().getSelectionModel().addListSelectionListener(new MatchListSelectionHandler());
        this.resultsTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new OsmPrimitivRenderer());
        this.resultsTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new OsmPrimitivRenderer());
        this.resultsTable.getColumnModel().getColumn(4).setCellRenderer(new ColorTableCellRenderer("Tags"));
        this.resultsTable.setSelectionMode(0);
        this.createLayout(this.resultsTable, true, Arrays.asList(new SideButton((Action)((Object)new ConfigureAction()), true), new SideButton((Action)((Object)new ConflationAction()), true)));
    }

    @Override
    public void conflationListChanged(ConflationCandidateList list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        List prims = event.getPrimitives();
        block0: for (OsmPrimitive p : prims) {
            for (ConflationCandidate c : this.candidates) {
                if (!c.getReferenceObject().equals((Object)p) && !c.getSubjectObject().equals((Object)p)) continue;
                this.candidates.remove(c);
                continue block0;
            }
        }
        this.tableModel.fireTableDataChanged();
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void dataChanged(DataChangedEvent event) {
    }

    public class ConflationOptionsDialog
    extends ExtendedDialog {
        private JPanel costsPanel;
        private JCheckBox distanceCheckBox;
        private JButton freezeReferenceButton;
        private JButton freezeSubjectButton;
        private JPanel jPanel3;
        private JPanel jPanel5;
        private JButton restoreReferenceButton;
        private JButton restoreSubjectButton;
        private JLabel referenceLayerLabel;
        private JPanel referencePanel;
        private JLabel referenceSelectionLabel;
        private JLabel subjectLayerLabel;
        private JPanel subjectPanel;
        private JLabel subjectSelectionLabel;
        ArrayList<OsmPrimitive> subjectSelection;
        ArrayList<OsmPrimitive> referenceSelection;
        OsmDataLayer referenceLayer;
        DataSet subjectDataSet;
        OsmDataLayer subjectLayer;
        DataSet referenceDataSet;

        public ConflationOptionsDialog() {
            super(Main.parent, I18n.tr((String)"Configure conflation options", (Object[])new Object[0]), new String[]{I18n.tr((String)"Conflate", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, false);
            this.subjectSelection = null;
            this.referenceSelection = null;
            this.initComponents();
        }

        private void initComponents() {
            this.referencePanel = new JPanel();
            this.referenceLayerLabel = new JLabel();
            this.referenceSelectionLabel = new JLabel();
            this.jPanel3 = new JPanel();
            this.restoreReferenceButton = new JButton((Action)((Object)new RestoreReferenceAction()));
            this.freezeReferenceButton = new JButton((Action)((Object)new FreezeReferenceAction()));
            this.subjectPanel = new JPanel();
            this.subjectLayerLabel = new JLabel();
            this.subjectSelectionLabel = new JLabel();
            this.jPanel5 = new JPanel();
            this.restoreSubjectButton = new JButton((Action)((Object)new RestoreSubjectAction()));
            this.freezeSubjectButton = new JButton((Action)((Object)new FreezeSubjectAction()));
            this.costsPanel = new JPanel();
            this.distanceCheckBox = new JCheckBox();
            JPanel pnl = new JPanel();
            pnl.setLayout(new BoxLayout(pnl, 3));
            this.referencePanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Reference", (Object[])new Object[0])));
            this.referencePanel.setLayout(new BoxLayout(this.referencePanel, 3));
            this.referenceLayerLabel.setText("(none)");
            this.referencePanel.add(this.referenceLayerLabel);
            this.referenceSelectionLabel.setText("Rel.:0 / Ways:0 / Nodes: 0");
            this.referencePanel.add(this.referenceSelectionLabel);
            this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
            this.restoreReferenceButton.setText(I18n.tr((String)"Restore", (Object[])new Object[0]));
            this.jPanel3.add(this.restoreReferenceButton);
            this.jPanel3.add(this.freezeReferenceButton);
            this.referencePanel.add(this.jPanel3);
            pnl.add(this.referencePanel);
            this.subjectPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Subject", (Object[])new Object[0])));
            this.subjectPanel.setLayout(new BoxLayout(this.subjectPanel, 3));
            this.subjectLayerLabel.setText("(none)");
            this.subjectPanel.add(this.subjectLayerLabel);
            this.subjectSelectionLabel.setText("Rel.:0 / Ways:0 / Nodes: 0");
            this.subjectPanel.add(this.subjectSelectionLabel);
            this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 2));
            this.restoreSubjectButton.setText(I18n.tr((String)"Restore", (Object[])new Object[0]));
            this.jPanel5.add(this.restoreSubjectButton);
            this.freezeSubjectButton.setText(I18n.tr((String)"Freeze", (Object[])new Object[0]));
            this.jPanel5.add(this.freezeSubjectButton);
            this.subjectPanel.add(this.jPanel5);
            pnl.add(this.subjectPanel);
            this.costsPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Costs", (Object[])new Object[0])));
            this.costsPanel.setLayout(new BoxLayout(this.costsPanel, 2));
            this.distanceCheckBox.setSelected(true);
            this.distanceCheckBox.setText(I18n.tr((String)"Distance", (Object[])new Object[0]));
            this.distanceCheckBox.setEnabled(false);
            this.costsPanel.add(this.distanceCheckBox);
            pnl.add(this.costsPanel);
            this.setContent(pnl);
            this.setupDialog();
        }

        protected void buttonAction(int buttonIndex, ActionEvent evt) {
            super.buttonAction(buttonIndex, evt);
            if (buttonIndex == 0) {
                this.performConflation();
            }
        }

        private void performConflation() {
            int n = this.subjectSelection.size();
            int m = this.referenceSelection.size();
            double[][] cost = new double[n][m];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < m; ++j) {
                    cost[i][j] = ConflationUtils.calcCost(this.subjectSelection.get(i), this.referenceSelection.get(j));
                }
            }
            int[][] assignment = HungarianAlgorithm.hgAlgorithm((double[][])cost, (String)"min");
            ConflationToggleDialog.this.candidates.clear();
            for (int i = 0; i < n; ++i) {
                int subIdx = assignment[i][0];
                int refIdx = assignment[i][1];
                OsmPrimitive subObject = subIdx < n ? this.subjectSelection.get(subIdx) : null;
                OsmPrimitive refObject = refIdx < m ? this.referenceSelection.get(refIdx) : null;
                if (subObject == null || refObject == null || ConflationToggleDialog.this.candidates.hasCandidate(refObject, subObject) || ConflationToggleDialog.this.candidates.hasCandidate(subObject, refObject)) continue;
                ConflationToggleDialog.this.candidates.add(new ConflationCandidate(refObject, this.referenceLayer, subObject, this.subjectLayer, cost[subIdx][refIdx]));
            }
            try {
                ConflationToggleDialog.this.conflationLayer = new ConflationLayer(this.subjectLayer.data, ConflationToggleDialog.this.candidates);
                Main.main.addLayer((Layer)ConflationToggleDialog.this.conflationLayer);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Main.parent, ex.toString(), "Error adding conflation layer", 0);
            }
        }

        class FreezeReferenceAction
        extends JosmAction {
            public FreezeReferenceAction() {
                super(I18n.tr((String)"Freeze", (Object[])new Object[0]), null, I18n.tr((String)"Freeze subject selection", (Object[])new Object[0]), null, false);
            }

            public void actionPerformed(ActionEvent e) {
                if (ConflationOptionsDialog.this.referenceDataSet == null || ConflationOptionsDialog.this.referenceDataSet == Main.main.getCurrentDataSet()) {
                    // empty if block
                }
                ConflationOptionsDialog.this.referenceDataSet = Main.main.getCurrentDataSet();
                ConflationOptionsDialog.this.referenceLayer = Main.main.getEditLayer();
                if (ConflationOptionsDialog.this.referenceDataSet == null || ConflationOptionsDialog.this.referenceLayer == null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No valid OSM data layer present.", (Object[])new Object[0]), I18n.tr((String)"Error freezing selection", (Object[])new Object[0]), 0);
                    return;
                }
                ConflationOptionsDialog.this.referenceSelection = new ArrayList(ConflationOptionsDialog.this.referenceDataSet.getSelected());
                if (ConflationOptionsDialog.this.referenceSelection.isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Nothing is selected, please try again.", (Object[])new Object[0]), I18n.tr((String)"Empty selection", (Object[])new Object[0]), 0);
                    return;
                }
                int numNodes = 0;
                int numWays = 0;
                int numRelations = 0;
                for (OsmPrimitive p : ConflationOptionsDialog.this.referenceSelection) {
                    switch (p.getType()) {
                        case NODE: {
                            ++numNodes;
                            break;
                        }
                        case WAY: {
                            ++numWays;
                            break;
                        }
                        case RELATION: {
                            ++numRelations;
                        }
                    }
                }
                ConflationOptionsDialog.this.referenceLayerLabel.setText(ConflationOptionsDialog.this.referenceLayer.getName());
                ConflationOptionsDialog.this.referenceSelectionLabel.setText(String.format("Rel.: %d / Ways: %d / Nodes: %d", numRelations, numWays, numNodes));
            }
        }

        class FreezeSubjectAction
        extends JosmAction {
            public FreezeSubjectAction() {
                super(I18n.tr((String)"Freeze", (Object[])new Object[0]), null, I18n.tr((String)"Freeze subject selection", (Object[])new Object[0]), null, false);
            }

            public void actionPerformed(ActionEvent e) {
                if (ConflationOptionsDialog.this.subjectDataSet == null || ConflationOptionsDialog.this.subjectDataSet == Main.main.getCurrentDataSet()) {
                    // empty if block
                }
                ConflationOptionsDialog.this.subjectDataSet = Main.main.getCurrentDataSet();
                ConflationOptionsDialog.this.subjectLayer = Main.main.getEditLayer();
                if (ConflationOptionsDialog.this.subjectDataSet == null || ConflationOptionsDialog.this.subjectLayer == null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No valid OSM data layer present.", (Object[])new Object[0]), I18n.tr((String)"Error freezing selection", (Object[])new Object[0]), 0);
                    return;
                }
                ConflationOptionsDialog.this.subjectSelection = new ArrayList(ConflationOptionsDialog.this.subjectDataSet.getSelected());
                if (ConflationOptionsDialog.this.subjectSelection.isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Nothing is selected, please try again.", (Object[])new Object[0]), I18n.tr((String)"Empty selection", (Object[])new Object[0]), 0);
                    return;
                }
                int numNodes = 0;
                int numWays = 0;
                int numRelations = 0;
                for (OsmPrimitive p : ConflationOptionsDialog.this.subjectSelection) {
                    switch (p.getType()) {
                        case NODE: {
                            ++numNodes;
                            break;
                        }
                        case WAY: {
                            ++numWays;
                            break;
                        }
                        case RELATION: {
                            ++numRelations;
                        }
                    }
                }
                ConflationOptionsDialog.this.subjectLayerLabel.setText(ConflationOptionsDialog.this.subjectLayer.getName());
                ConflationOptionsDialog.this.subjectSelectionLabel.setText(String.format("Rel.: %d / Ways: %d / Nodes: %d", numRelations, numWays, numNodes));
            }
        }

        class RestoreReferenceAction
        extends JosmAction {
            public RestoreReferenceAction() {
                super(I18n.tr((String)"Restore", (Object[])new Object[0]), null, I18n.tr((String)"Restore reference selection", (Object[])new Object[0]), null, false);
            }

            public void actionPerformed(ActionEvent e) {
                if (ConflationOptionsDialog.this.referenceLayer != null && ConflationOptionsDialog.this.referenceDataSet != null && ConflationOptionsDialog.this.referenceSelection != null && !ConflationOptionsDialog.this.referenceSelection.isEmpty()) {
                    Main.map.mapView.setActiveLayer((Layer)ConflationOptionsDialog.this.referenceLayer);
                    ConflationOptionsDialog.this.referenceLayer.setVisible(true);
                    ConflationOptionsDialog.this.referenceDataSet.setSelected(ConflationOptionsDialog.this.referenceSelection);
                }
            }
        }

        class RestoreSubjectAction
        extends JosmAction {
            public RestoreSubjectAction() {
                super(I18n.tr((String)"Restore", (Object[])new Object[0]), null, I18n.tr((String)"Restore subject selection", (Object[])new Object[0]), null, false);
            }

            public void actionPerformed(ActionEvent e) {
                if (ConflationOptionsDialog.this.subjectLayer != null && ConflationOptionsDialog.this.subjectDataSet != null && ConflationOptionsDialog.this.subjectSelection != null && !ConflationOptionsDialog.this.subjectSelection.isEmpty()) {
                    Main.map.mapView.setActiveLayer((Layer)ConflationOptionsDialog.this.subjectLayer);
                    ConflationOptionsDialog.this.subjectLayer.setVisible(true);
                    ConflationOptionsDialog.this.subjectDataSet.setSelected(ConflationOptionsDialog.this.subjectSelection);
                }
            }
        }
    }

    class ConflationAction
    extends JosmAction {
        public ConflationAction() {
            super(I18n.tr((String)"Replace Geometry", (Object[])new Object[0]), null, I18n.tr((String)"Replace geometry", (Object[])new Object[0]), Shortcut.registerShortcut((String)"conflation:replace", (String)I18n.tr((String)"Conflation: {0}", (Object[])new Object[]{I18n.tr((String)"Replace", (Object[])new Object[0])}), (int)70, (int)5008), false);
        }

        public void actionPerformed(ActionEvent e) {
            ConflationCandidate c = ConflationToggleDialog.this.conflationLayer.getSelectedCandidate();
            if (c.getReferenceLayer() != c.getSubjectLayer()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Conflation between layers isn't supported yet.", (Object[])new Object[0]), I18n.tr((String)"Cannot conflate between layes", (Object[])new Object[0]), 0);
                return;
            }
            if (ReplaceGeometryUtils.replace((OsmPrimitive)c.getReferenceObject(), (OsmPrimitive)c.getSubjectObject())) {
                ConflationToggleDialog.this.candidates.remove(c);
            }
        }
    }

    public static class LayerListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Layer layer = (Layer)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, layer.getName(), index, isSelected, cellHasFocus);
            Icon icon = layer.getIcon();
            label.setIcon(icon);
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }

    class ColorTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private String columnName;

        public ColorTableCellRenderer(String column) {
            this.columnName = column;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object columnValue = table.getValueAt(row, table.getColumnModel().getColumnIndex(this.columnName));
            if (value != null) {
                this.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
                if (columnValue.equals("Conflicts!")) {
                    this.setBackground(Color.red);
                } else {
                    this.setBackground(Color.green);
                }
            }
            return this;
        }
    }

    class MatchListSelectionHandler
    implements ListSelectionListener {
        MatchListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int firstIndex = lsm.getMinSelectionIndex();
            int lastIndex = lsm.getMaxSelectionIndex();
            boolean isAdjusting = e.getValueIsAdjusting();
            if (isAdjusting) {
                return;
            }
            if (!lsm.isSelectionEmpty() && firstIndex == lastIndex && firstIndex < ConflationToggleDialog.this.candidates.size()) {
                ConflationCandidate c = ConflationToggleDialog.this.candidates.get(firstIndex);
                OsmPrimitive reference = c.getReferenceObject();
                OsmPrimitive subject = c.getSubjectObject();
                ConflationToggleDialog.this.conflationLayer.setSelectedCandidate(c);
                reference.getDataSet().clearSelection();
                subject.getDataSet().clearSelection();
                reference.getDataSet().addSelected(new PrimitiveId[]{reference});
                subject.getDataSet().addSelected(new PrimitiveId[]{subject});
                BoundingXYVisitor box = new BoundingXYVisitor();
                box.computeBoundingBox(Arrays.asList(reference, subject));
                if (box.getBounds() == null) {
                    return;
                }
                box.enlargeBoundingBox();
                Main.map.mapView.recalculateCenterScale(box);
            }
        }
    }

    public class ConfigureAction
    extends JosmAction {
        public ConfigureAction() {
            super(I18n.tr((String)"Configure", (Object[])new Object[0]), null, I18n.tr((String)"Configure conflation", (Object[])new Object[0]), Shortcut.registerShortcut((String)"conflation:configure", (String)I18n.tr((String)"Conflation: {0}", (Object[])new Object[]{I18n.tr((String)"Conflation", (Object[])new Object[0])}), (int)70, (int)5008), false);
        }

        public void actionPerformed(ActionEvent e) {
            ConflationToggleDialog.this.optionsDialog.setVisible(true);
        }
    }
}

