/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.conflation.ConflationCandidate;
import org.openstreetmap.josm.plugins.conflation.ConflationCandidateList;
import org.openstreetmap.josm.plugins.conflation.ConflationUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflationLayer
extends Layer
implements MapView.LayerChangeListener {
    protected ConflationCandidateList candidates;
    protected ConflationCandidate selectedCandidate = null;

    public ConflationLayer(DataSet ds, ConflationCandidateList candidates) {
        super(I18n.tr((String)"Conflation", (Object[])new Object[0]));
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        this.candidates = candidates;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        Graphics2D g2 = g;
        BasicStroke line = new BasicStroke(3.0f, 1, 1);
        g2.setStroke(line);
        double PHI = Math.toRadians(20.0);
        double cosPHI = Math.cos(PHI);
        double sinPHI = Math.sin(PHI);
        for (ConflationCandidate candidate : this.candidates) {
            if (candidate.equals(this.selectedCandidate)) {
                g2.setColor(Color.blue);
            } else {
                g2.setColor(Color.cyan);
            }
            OsmPrimitive reference = candidate.getReferenceObject();
            OsmPrimitive subject = candidate.getSubjectObject();
            if (reference == null || subject == null) continue;
            GeneralPath path = new GeneralPath();
            Point p1 = mv.getPoint(ConflationUtils.getCenter(reference));
            Point p2 = mv.getPoint(ConflationUtils.getCenter(subject));
            path.moveTo(p1.x, p1.y);
            path.lineTo(p2.x, p2.y);
            double segmentLength = p1.distance(p2);
            if (segmentLength != 0.0) {
                double l = (10.0 + (double)line.getLineWidth()) / segmentLength;
                double sx = l * (double)(p1.x - p2.x);
                double sy = l * (double)(p1.y - p2.y);
                path.moveTo((double)p2.x + cosPHI * sx - sinPHI * sy, (double)p2.y + sinPHI * sx + cosPHI * sy);
                path.lineTo(p2.x, p2.y);
                path.lineTo((double)p2.x + cosPHI * sx + sinPHI * sy, (double)p2.y - sinPHI * sx + cosPHI * sy);
            }
            g2.draw(path);
        }
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"gpx_small");
    }

    public String getToolTipText() {
        return "Conflation tool tip text goes here";
    }

    public void mergeFrom(Layer layer) {
    }

    public boolean isMergable(Layer layer) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (ConflationCandidate candidate : this.candidates) {
            OsmPrimitive reference = candidate.getReferenceObject();
            OsmPrimitive subject = candidate.getSubjectObject();
            if (reference != null && reference instanceof Node) {
                v.visit((Node)reference);
            }
            if (subject == null || !(subject instanceof Node)) continue;
            v.visit((Node)subject);
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public void activeLayerChange(Layer layer, Layer layer1) {
    }

    public void layerAdded(Layer layer) {
    }

    public void layerRemoved(Layer layer) {
    }

    public ConflationCandidateList getCandidates() {
        return this.candidates;
    }

    public void setSelectedCandidate(ConflationCandidate c) {
        this.selectedCandidate = c;
    }

    public ConflationCandidate getSelectedCandidate() {
        return this.selectedCandidate;
    }
}

