/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.conflation.ConflationUtils;
import org.openstreetmap.josm.tools.I18n;

public class ConflationCandidate {
    OsmPrimitive referenceObject;
    OsmDataLayer referenceLayer;
    OsmPrimitive subjectObject;
    OsmDataLayer subjectLayer;
    double cost;
    double distance;

    public ConflationCandidate(OsmPrimitive referenceObject, OsmDataLayer referenceLayer, OsmPrimitive subjectObject, OsmDataLayer subjectLayer, double cost) {
        if (referenceObject == null || subjectObject == null) {
            throw new IllegalArgumentException(I18n.tr((String)"Invalid reference or subject", (Object[])new Object[0]));
        }
        this.referenceObject = referenceObject;
        this.referenceLayer = referenceLayer;
        this.subjectObject = subjectObject;
        this.subjectLayer = subjectLayer;
        this.cost = cost;
        this.distance = ConflationUtils.getCenter(referenceObject).distance(ConflationUtils.getCenter(subjectObject));
    }

    public OsmPrimitive getReferenceObject() {
        return this.referenceObject;
    }

    public OsmDataLayer getReferenceLayer() {
        return this.referenceLayer;
    }

    public OsmDataLayer getSubjectLayer() {
        return this.subjectLayer;
    }

    public OsmPrimitive getSubjectObject() {
        return this.subjectObject;
    }

    public Object getCost() {
        return this.cost;
    }

    public Object getDistance() {
        return this.distance;
    }
}

