/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.Namespace;
import org.jdom.Verifier;

class AttributeList
extends AbstractList
implements Serializable {
    private static final int INITIAL_ARRAY_SIZE = 5;
    private Attribute[] elementData;
    private int size;
    private Element parent;

    private AttributeList() {
    }

    AttributeList(Element element) {
        this.parent = element;
    }

    @Override
    public boolean add(Object object) {
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            int n = this.indexOfDuplicate(attribute);
            if (n < 0) {
                this.add(this.size(), attribute);
            } else {
                this.set(n, attribute);
            }
        } else {
            if (object == null) {
                throw new IllegalAddException("Cannot add null attribute");
            }
            throw new IllegalAddException("Class " + object.getClass().getName() + " is not an attribute");
        }
        return true;
    }

    @Override
    public void add(int n, Object object) {
        Attribute attribute;
        if (object instanceof Attribute) {
            attribute = (Attribute)object;
            int n2 = this.indexOfDuplicate(attribute);
            if (n2 >= 0) {
                throw new IllegalAddException("Cannot add duplicate attribute");
            }
        } else {
            if (object == null) {
                throw new IllegalAddException("Cannot add null attribute");
            }
            throw new IllegalAddException("Class " + object.getClass().getName() + " is not an attribute");
        }
        this.add(n, attribute);
        ++this.modCount;
    }

    @Override
    void add(int n, Attribute attribute) {
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        String string = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (string != null) {
            throw new IllegalAddException(this.parent, attribute, string);
        }
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        attribute.setParent(this.parent);
        this.ensureCapacity(this.size + 1);
        if (n == this.size) {
            this.elementData[this.size++] = attribute;
        } else {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
            this.elementData[n] = attribute;
            ++this.size;
        }
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        if (collection == null || collection.size() == 0) {
            return false;
        }
        this.ensureCapacity(this.size() + collection.size());
        int n2 = 0;
        try {
            for (Object e : collection) {
                this.add(n + n2, e);
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {
            for (int i = 0; i < n2; ++i) {
                this.remove(n);
            }
            throw runtimeException;
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                Attribute attribute = this.elementData[i];
                attribute.setParent(null);
            }
            this.elementData = null;
            this.size = 0;
        }
        ++this.modCount;
    }

    private void ensureCapacity(int n) {
        if (this.elementData == null) {
            this.elementData = new Attribute[Math.max(n, 5)];
        } else {
            int n2 = this.elementData.length;
            if (n > n2) {
                Attribute[] attributeArray = this.elementData;
                int n3 = n2 * 3 / 2 + 1;
                if (n3 < n) {
                    n3 = n;
                }
                this.elementData = new Attribute[n3];
                System.arraycopy(attributeArray, 0, this.elementData, 0, this.size);
            }
        }
    }

    @Override
    public Object get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        return this.elementData[n];
    }

    Object get(String string, Namespace namespace) {
        int n = this.indexOf(string, namespace);
        if (n < 0) {
            return null;
        }
        return this.elementData[n];
    }

    int indexOf(String string, Namespace namespace) {
        String string2 = namespace.getURI();
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                Attribute attribute = this.elementData[i];
                String string3 = attribute.getNamespaceURI();
                String string4 = attribute.getName();
                if (!string3.equals(string2) || !string4.equals(string)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        Attribute attribute = this.elementData[n];
        attribute.setParent(null);
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        ++this.modCount;
        return attribute;
    }

    boolean remove(String string, Namespace namespace) {
        int n = this.indexOf(string, namespace);
        if (n < 0) {
            return false;
        }
        this.remove(n);
        return true;
    }

    @Override
    public Object set(int n, Object object) {
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            int n2 = this.indexOfDuplicate(attribute);
            if (n2 >= 0 && n2 != n) {
                throw new IllegalAddException("Cannot set duplicate attribute");
            }
            return this.set(n, attribute);
        }
        if (object == null) {
            throw new IllegalAddException("Cannot add null attribute");
        }
        throw new IllegalAddException("Class " + object.getClass().getName() + " is not an attribute");
    }

    @Override
    Object set(int n, Attribute attribute) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        String string = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (string != null) {
            throw new IllegalAddException(this.parent, attribute, string);
        }
        Attribute attribute2 = this.elementData[n];
        attribute2.setParent(null);
        this.elementData[n] = attribute;
        attribute.setParent(this.parent);
        return attribute2;
    }

    private int indexOfDuplicate(Attribute attribute) {
        int n = -1;
        String string = attribute.getName();
        Namespace namespace = attribute.getNamespace();
        n = this.indexOf(string, namespace);
        return n;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

