/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.ManyAuthoritiesFactory;
import org.geotools.referencing.factory.ThreadedAuthorityFactory;
import org.geotools.resources.UnmodifiableArrayList;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class DefaultAuthorityFactory
extends ThreadedAuthorityFactory
implements CRSAuthorityFactory {
    private static List<String> AUTHORITY_LESS = UnmodifiableArrayList.wrap(new String[]{"WGS84(DD)"});

    DefaultAuthorityFactory(boolean longitudeFirst) {
        super(DefaultAuthorityFactory.getBackingFactory(longitudeFirst));
    }

    private static AbstractAuthorityFactory getBackingFactory(boolean longitudeFirst) {
        Hints hints = GeoTools.getDefaultHints();
        if (longitudeFirst) {
            hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        }
        Collection<CRSAuthorityFactory> factories = ReferencingFactoryFinder.getCRSAuthorityFactories(hints);
        if (Boolean.TRUE.equals(hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE))) {
            factories = new ArrayList<CRSAuthorityFactory>(factories);
            LinkedHashSet<Citation> authorities = new LinkedHashSet<Citation>();
            for (CRSAuthorityFactory factory : factories) {
                authorities.add(factory.getAuthority());
            }
            block1: for (CRSAuthorityFactory factory : ReferencingFactoryFinder.getCRSAuthorityFactories(hints)) {
                Citation authority = factory.getAuthority();
                if (authorities.contains(authority)) continue;
                for (Citation check : authorities) {
                    if (!Citations.identifierMatches(authority, check)) continue;
                    continue block1;
                }
                factories.add(factory);
            }
        }
        return new ManyAuthoritiesFactory(factories);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        if (code != null && (code = code.trim()).equalsIgnoreCase("WGS84(DD)")) {
            return DefaultGeographicCRS.WGS84;
        }
        assert (!AUTHORITY_LESS.contains(code)) : code;
        return super.createCoordinateReferenceSystem(code);
    }
}

