/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

public class IntList {
    private int[] _array;
    private int _limit;
    private int fillval = 0;
    private static final int _default_size = 128;

    public IntList() {
        this(128);
    }

    public IntList(int n) {
        this(n, 0);
    }

    public IntList(int n, int n2) {
        this._array = new int[n];
        if (this.fillval != 0) {
            this.fillval = n2;
            this.fillArray(this.fillval, this._array, 0);
        }
        this._limit = 0;
    }

    private void fillArray(int n, int[] nArray, int n2) {
        for (int i = n2; i < nArray.length; ++i) {
            nArray[i] = n;
        }
    }

    public boolean add(int n) {
        if (this._limit == this._array.length) {
            this.growArray(this._limit * 2);
        }
        this._array[this._limit++] = n;
        return true;
    }

    public boolean addAll(IntList intList) {
        if (intList._limit != 0) {
            if (this._limit + intList._limit > this._array.length) {
                this.growArray(this._limit + intList._limit);
            }
            System.arraycopy(intList._array, 0, this._array, this._limit, intList._limit);
            this._limit += intList._limit;
        }
        return true;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object != null && object.getClass() == this.getClass()) {
            IntList intList = (IntList)object;
            if (intList._limit == this._limit) {
                bl = true;
                for (int i = 0; bl && i < this._limit; ++i) {
                    bl = this._array[i] == intList._array[i];
                }
            }
        }
        return bl;
    }

    public int get(int n) {
        if (n >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        return this._array[n];
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._limit; ++i) {
            n = 31 * n + this._array[i];
        }
        return n;
    }

    public int size() {
        return this._limit;
    }

    private void growArray(int n) {
        int n2 = n == this._array.length ? n + 1 : n;
        int[] nArray = new int[n2];
        if (this.fillval != 0) {
            this.fillArray(this.fillval, nArray, this._array.length);
        }
        System.arraycopy(this._array, 0, nArray, 0, this._limit);
        this._array = nArray;
    }
}

