/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import java.util.ArrayList;
import java.util.List;

public class IndexedNestedRingTester {
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private Envelope totalEnv = new Envelope();
    private SpatialIndex index;
    private Coordinate nestedPt;

    public IndexedNestedRingTester(GeometryGraph geometryGraph) {
        this.graph = geometryGraph;
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public void add(LinearRing linearRing) {
        this.rings.add(linearRing);
        this.totalEnv.expandToInclude(linearRing.getEnvelopeInternal());
    }

    public boolean isNonNested() {
        this.buildIndex();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing linearRing = (LinearRing)this.rings.get(i);
            Coordinate[] coordinateArray = linearRing.getCoordinates();
            List list = this.index.query(linearRing.getEnvelopeInternal());
            for (int j = 0; j < list.size(); ++j) {
                boolean bl;
                Coordinate coordinate;
                LinearRing linearRing2 = (LinearRing)list.get(j);
                Coordinate[] coordinateArray2 = linearRing2.getCoordinates();
                if (linearRing == linearRing2 || !linearRing.getEnvelopeInternal().intersects(linearRing2.getEnvelopeInternal()) || (coordinate = IsValidOp.findPtNotNode(coordinateArray, linearRing2, this.graph)) == null || !(bl = CGAlgorithms.isPointInRing(coordinate, coordinateArray2))) continue;
                this.nestedPt = coordinate;
                return false;
            }
        }
        return true;
    }

    private void buildIndex() {
        this.index = new STRtree();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing linearRing = (LinearRing)this.rings.get(i);
            Envelope envelope = linearRing.getEnvelopeInternal();
            this.index.insert(envelope, linearRing);
        }
    }
}

