/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.noding.InteriorIntersectionFinder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import java.util.Collection;

public class FastNodingValidator {
    private LineIntersector li = new RobustLineIntersector();
    private Collection segStrings;
    private boolean findAllIntersections = false;
    private InteriorIntersectionFinder segInt = null;
    private boolean isValid = true;

    public FastNodingValidator(Collection collection) {
        this.segStrings = collection;
    }

    public String getErrorMessage() {
        if (this.isValid) {
            return "no intersections found";
        }
        Coordinate[] coordinateArray = this.segInt.getIntersectionSegments();
        return "found non-noded intersection between " + WKTWriter.toLineString(coordinateArray[0], coordinateArray[1]) + " and " + WKTWriter.toLineString(coordinateArray[2], coordinateArray[3]);
    }

    public void checkValid() {
        this.execute();
        if (!this.isValid) {
            throw new TopologyException(this.getErrorMessage(), this.segInt.getInteriorIntersection());
        }
    }

    private void execute() {
        if (this.segInt != null) {
            return;
        }
        this.checkInteriorIntersections();
    }

    private void checkInteriorIntersections() {
        this.isValid = true;
        this.segInt = new InteriorIntersectionFinder(this.li);
        this.segInt.setFindAllIntersections(this.findAllIntersections);
        MCIndexNoder mCIndexNoder = new MCIndexNoder();
        mCIndexNoder.setSegmentIntersector(this.segInt);
        mCIndexNoder.computeNodes(this.segStrings);
        if (this.segInt.hasIntersection()) {
            this.isValid = false;
            return;
        }
    }
}

