/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.modules.Module;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;

public abstract class AbstractImporter
extends OsmImporter
implements OdConstants {
    protected AbstractDataSetHandler handler;
    protected File file;

    public AbstractImporter(ExtensionFileFilter filter) {
        super(filter);
    }

    protected final AbstractDataSetHandler findDataSetHandler(File file) {
        for (Module module : ModuleHandler.moduleList) {
            for (AbstractDataSetHandler dsh : module.getHandlers()) {
                if (!dsh.acceptsFile(file)) continue;
                return dsh;
            }
        }
        return null;
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        if (file != null) {
            this.file = file;
            this.handler = this.findDataSetHandler(file);
        }
        super.importData(file, progressMonitor);
    }

    protected OsmDataLayer createLayer(DataSet dataSet, File associatedFile, String layerName) {
        if (this.handler != null) {
            this.handler.setAssociatedFile(associatedFile);
            this.handler.setSourceDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date(associatedFile.lastModified())));
            if (!Main.pref.getBoolean("opendata.rawdata")) {
                this.handler.updateDataSet(dataSet);
            }
            this.handler.checkDataSetSource(dataSet);
            this.handler.checkNames(dataSet);
        }
        return new OdDataLayer(dataSet, layerName, associatedFile, this.handler);
    }
}

