/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.HashMap;
import org.jdom.IllegalNameException;
import org.jdom.NamespaceKey;
import org.jdom.Verifier;

public final class Namespace {
    private static HashMap namespaces;
    public static final Namespace NO_NAMESPACE;
    public static final Namespace XML_NAMESPACE;
    private String prefix;
    private String uri;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Namespace getNamespace(String string, String string2) {
        Namespace namespace;
        if (string == null || string.trim().equals("")) {
            if (string2 == null || string2.trim().equals("")) {
                return NO_NAMESPACE;
            }
            string = "";
        } else if (string2 == null || string2.trim().equals("")) {
            string2 = "";
        }
        NamespaceKey namespaceKey = new NamespaceKey(string, string2);
        Object object = namespaces;
        synchronized (object) {
            namespace = (Namespace)namespaces.get(namespaceKey);
        }
        if (namespace != null) {
            return namespace;
        }
        object = Verifier.checkNamespacePrefix(string);
        if (object != null) {
            throw new IllegalNameException(string, "Namespace prefix", (String)object);
        }
        object = Verifier.checkNamespaceURI(string2);
        if (object != null) {
            throw new IllegalNameException(string2, "Namespace URI", (String)object);
        }
        if (!string.equals("") && string2.equals("")) {
            throw new IllegalNameException("", "namespace", "Namespace URIs must be non-null and non-empty Strings");
        }
        if (string.equals("xml")) {
            throw new IllegalNameException(string, "Namespace prefix", "The xml prefix can only be bound to http://www.w3.org/XML/1998/namespace");
        }
        if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new IllegalNameException(string2, "Namespace URI", "The http://www.w3.org/XML/1998/namespace must be bound to the xml prefix.");
        }
        Namespace namespace2 = new Namespace(string, string2);
        HashMap hashMap = namespaces;
        synchronized (hashMap) {
            namespaces.put(namespaceKey, namespace2);
        }
        return namespace2;
    }

    private Namespace(String string, String string2) {
        this.prefix = string;
        this.uri = string2;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Namespace) {
            return this.uri.equals(((Namespace)object).uri);
        }
        return false;
    }

    public String toString() {
        return "[Namespace: prefix \"" + this.prefix + "\" is mapped to URI \"" + this.uri + "\"]";
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    static {
        NO_NAMESPACE = new Namespace("", "");
        XML_NAMESPACE = new Namespace("xml", "http://www.w3.org/XML/1998/namespace");
        namespaces = new HashMap(16);
        namespaces.put(new NamespaceKey(NO_NAMESPACE), NO_NAMESPACE);
        namespaces.put(new NamespaceKey(XML_NAMESPACE), XML_NAMESPACE);
    }
}

