/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.io.Serializable;
import javax.vecmath.SingularMatrixException;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.operation.Matrix;

public class Matrix1
implements XMatrix,
Serializable {
    private static final long serialVersionUID = -4829171016106097031L;
    public double m00;
    public static final int SIZE = 1;

    public Matrix1() {
        this.m00 = 1.0;
    }

    public Matrix1(double m00) {
        this.m00 = m00;
    }

    public Matrix1(Matrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 = matrix.getElement(0, 0);
    }

    @Override
    public final int getNumRow() {
        return 1;
    }

    @Override
    public final int getNumCol() {
        return 1;
    }

    @Override
    public final double getElement(int row, int col) {
        if (row == 0 && col == 0) {
            return this.m00;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final void setElement(int row, int col, double value) {
        if (row != 0 || col != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.m00 = value;
    }

    @Override
    public final void setZero() {
        this.m00 = 0.0;
    }

    @Override
    public final void setIdentity() {
        this.m00 = 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0;
    }

    @Override
    public final boolean isIdentity(double tolerance) {
        return Math.abs(this.m00 - 1.0) <= Math.abs(tolerance);
    }

    @Override
    public final boolean isAffine() {
        return this.m00 == 1.0;
    }

    @Override
    public final void invert() {
        if (this.m00 == 0.0) {
            throw new SingularMatrixException();
        }
        this.m00 = 1.0 / this.m00;
    }

    @Override
    public final void multiply(Matrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 *= matrix.getElement(0, 0);
    }

    @Override
    public boolean equals(Matrix matrix, double tolerance) {
        return GeneralMatrix.epsilonEquals(this, matrix, tolerance);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            Matrix1 that = (Matrix1)object;
            return Double.doubleToLongBits(this.m00) == Double.doubleToLongBits(that.m00);
        }
        return false;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.m00) ^ 0xBCFB568C01624679L);
    }

    public String toString() {
        return GeneralMatrix.toString(this);
    }

    @Override
    public Matrix1 clone() {
        try {
            return (Matrix1)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

