/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.datum.Spheroid;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.referencing.datum.Ellipsoid;

public class DefaultEllipsoid
extends AbstractIdentifiedObject
implements Ellipsoid {
    private static final long serialVersionUID = -1149451543954764081L;
    public static final DefaultEllipsoid WGS84 = DefaultEllipsoid.createFlattenedSphere("WGS84", 6378137.0, 298.257223563, SI.METER);
    public static final DefaultEllipsoid GRS80 = DefaultEllipsoid.createFlattenedSphere("GRS80", 6378137.0, 298.257222101, SI.METER);
    public static final DefaultEllipsoid INTERNATIONAL_1924 = DefaultEllipsoid.createFlattenedSphere("International 1924", 6378388.0, 297.0, SI.METER);
    public static final DefaultEllipsoid CLARKE_1866 = DefaultEllipsoid.createFlattenedSphere("Clarke 1866", 6378206.4, 294.9786982, SI.METER);
    public static final DefaultEllipsoid SPHERE = DefaultEllipsoid.createEllipsoid("SPHERE", 6371000.0, 6371000.0, SI.METER);
    private final double semiMajorAxis;
    private final double semiMinorAxis;
    private final double inverseFlattening;
    private final boolean ivfDefinitive;
    private final Unit<Length> unit;

    protected DefaultEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, double inverseFlattening, boolean ivfDefinitive, Unit<Length> unit) {
        super(properties);
        this.unit = unit;
        this.semiMajorAxis = DefaultEllipsoid.check("semiMajorAxis", semiMajorAxis);
        this.semiMinorAxis = DefaultEllipsoid.check("semiMinorAxis", semiMinorAxis);
        this.inverseFlattening = DefaultEllipsoid.check("inverseFlattening", inverseFlattening);
        this.ivfDefinitive = ivfDefinitive;
        DefaultEllipsoid.ensureNonNull("unit", unit);
        DefaultEllipsoid.ensureLinearUnit(unit);
    }

    public static DefaultEllipsoid createEllipsoid(String name, double semiMajorAxis, double semiMinorAxis, Unit<Length> unit) {
        return DefaultEllipsoid.createEllipsoid(Collections.singletonMap("name", name), semiMajorAxis, semiMinorAxis, unit);
    }

    public static DefaultEllipsoid createEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, Unit<Length> unit) {
        if (semiMajorAxis == semiMinorAxis) {
            return new Spheroid(properties, semiMajorAxis, false, unit);
        }
        return new DefaultEllipsoid(properties, semiMajorAxis, semiMinorAxis, semiMajorAxis / (semiMajorAxis - semiMinorAxis), false, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(String name, double semiMajorAxis, double inverseFlattening, Unit<Length> unit) {
        return DefaultEllipsoid.createFlattenedSphere(Collections.singletonMap("name", name), semiMajorAxis, inverseFlattening, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(Map<String, ?> properties, double semiMajorAxis, double inverseFlattening, Unit<Length> unit) {
        if (Double.isInfinite(inverseFlattening)) {
            return new Spheroid(properties, semiMajorAxis, true, unit);
        }
        return new DefaultEllipsoid(properties, semiMajorAxis, semiMajorAxis * (1.0 - 1.0 / inverseFlattening), inverseFlattening, true, unit);
    }

    static double check(String name, double value) throws IllegalArgumentException {
        if (value > 0.0) {
            return value;
        }
        throw new IllegalArgumentException(Errors.format(58, name, value));
    }

    @Override
    public Unit<Length> getAxisUnit() {
        return this.unit;
    }

    @Override
    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    @Override
    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultEllipsoid that = (DefaultEllipsoid)object;
            return (!compareMetadata || this.ivfDefinitive == that.ivfDefinitive) && Utilities.equals(this.semiMajorAxis, that.semiMajorAxis) && Utilities.equals(this.semiMinorAxis, that.semiMinorAxis) && Utilities.equals(this.inverseFlattening, that.inverseFlattening) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        long longCode = 37L * Double.doubleToLongBits(this.semiMajorAxis);
        longCode = this.ivfDefinitive ? (long)((double)longCode + this.inverseFlattening) : (long)((double)longCode + this.semiMinorAxis);
        return (int)(longCode >>> 32) ^ (int)longCode;
    }
}

