/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.ShortCircuitedGeometryVisitor;
import com.vividsolutions.jts.operation.predicate.SegmentIntersectionTester;
import java.util.List;

class LineIntersectsVisitor
extends ShortCircuitedGeometryVisitor {
    private LineString rectLine;
    private Envelope rectEnv;
    private boolean intersects = false;

    public LineIntersectsVisitor(Polygon polygon) {
        this.rectLine = polygon.getExteriorRing();
        this.rectEnv = polygon.getEnvelopeInternal();
    }

    public boolean intersects() {
        return this.intersects;
    }

    @Override
    protected void visit(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        if (!this.rectEnv.intersects(envelope)) {
            return;
        }
        this.computeSegmentIntersection(geometry);
    }

    private void computeSegmentIntersection(Geometry geometry) {
        SegmentIntersectionTester segmentIntersectionTester = new SegmentIntersectionTester();
        List list = LinearComponentExtracter.getLines(geometry);
        boolean bl = segmentIntersectionTester.hasIntersectionWithLineStrings(this.rectLine, list);
        if (bl) {
            this.intersects = true;
            return;
        }
    }

    @Override
    protected boolean isDone() {
        return this.intersects;
    }
}

