/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.quadtree.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class NodeBase {
    protected List items = new ArrayList();
    protected Node[] subnode = new Node[4];

    public static int getSubnodeIndex(Envelope envelope, Coordinate coordinate) {
        int n = -1;
        if (envelope.getMinX() >= coordinate.x) {
            if (envelope.getMinY() >= coordinate.y) {
                n = 3;
            }
            if (envelope.getMaxY() <= coordinate.y) {
                n = 1;
            }
        }
        if (envelope.getMaxX() <= coordinate.x) {
            if (envelope.getMinY() >= coordinate.y) {
                n = 2;
            }
            if (envelope.getMaxY() <= coordinate.y) {
                n = 0;
            }
        }
        return n;
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    public void add(Object object) {
        this.items.add(object);
    }

    public boolean remove(Envelope envelope, Object object) {
        if (!this.isSearchMatch(envelope)) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null || !(bl = this.subnode[i].remove(envelope, object))) continue;
            if (!this.subnode[i].isPrunable()) break;
            this.subnode[i] = null;
            break;
        }
        if (bl) {
            return bl;
        }
        bl = this.items.remove(object);
        return bl;
    }

    public boolean isPrunable() {
        return !this.hasChildren() && !this.hasItems();
    }

    public boolean hasChildren() {
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean isSearchMatch(Envelope var1);

    public void visit(Envelope envelope, ItemVisitor itemVisitor) {
        if (!this.isSearchMatch(envelope)) {
            return;
        }
        this.visitItems(itemVisitor);
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            this.subnode[i].visit(envelope, itemVisitor);
        }
    }

    private void visitItems(ItemVisitor itemVisitor) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            itemVisitor.visitItem(iterator.next());
        }
    }
}

