/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;

public class CentralEndpointIntersector {
    private Coordinate[] pts;
    private Coordinate intPt = null;

    public static Coordinate getIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        CentralEndpointIntersector centralEndpointIntersector = new CentralEndpointIntersector(coordinate, coordinate2, coordinate3, coordinate4);
        return centralEndpointIntersector.getIntersection();
    }

    public CentralEndpointIntersector(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        this.pts = new Coordinate[]{coordinate, coordinate2, coordinate3, coordinate4};
        this.compute();
    }

    private void compute() {
        Coordinate coordinate = CentralEndpointIntersector.average(this.pts);
        this.intPt = this.findNearestPoint(coordinate, this.pts);
    }

    public Coordinate getIntersection() {
        return this.intPt;
    }

    private static Coordinate average(Coordinate[] coordinateArray) {
        Coordinate coordinate = new Coordinate();
        int n = coordinateArray.length;
        for (int i = 0; i < coordinateArray.length; ++i) {
            coordinate.x += coordinateArray[i].x;
            coordinate.y += coordinateArray[i].y;
        }
        if (n > 0) {
            coordinate.x /= (double)n;
            coordinate.y /= (double)n;
        }
        return coordinate;
    }

    private Coordinate findNearestPoint(Coordinate coordinate, Coordinate[] coordinateArray) {
        double d = Double.MAX_VALUE;
        Coordinate coordinate2 = null;
        for (int i = 0; i < coordinateArray.length; ++i) {
            double d2 = coordinate.distance(coordinateArray[i]);
            if (!(d2 < d)) continue;
            d = d2;
            coordinate2 = coordinateArray[i];
        }
        return coordinate2;
    }
}

