/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.transport;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class PistesCyclablesHandler
extends ToulouseDataSetHandler {
    protected final Map<String, Collection<String>> map = new HashMap<String, Collection<String>>();
    private String streetField;

    public PistesCyclablesHandler() {
        this("Nom_voie");
    }

    public PistesCyclablesHandler(String streetField) {
        super(12544, true, "cycleway", "cycleway:right", "cycleway:left", "cycleway:both", "highway=cycleway", "ramp:bicycle=yes", "bicycle=yes", "barrier=cycle_barrier");
        this.setWikiPage("R\u00e9seau cyclable et vert");
        this.addForbiddenTag(new String[]{"cycleway=no"});
        this.streetField = streetField;
        this.map.put("secondary", Arrays.asList("AVENUE", "Av ", "av ", "Avenue ", "avenue ", "BOULEVARD ", "bd ", "ALLEE", "Allee", "allee", "PONT ", "Pont ", "PORT ", "ROUTE ", "Rte ", "BOULINGRIN", "boulingrin"));
        this.map.put("residential", Arrays.asList("CHEMIN ", "Chemin ", "chemin ", "IMPASSE ", "imp ", "PLACE ", "Place ", "place ", "RUE ", "Rue ", "rue ", "QUAI", "VOIE ", "grand rue"));
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsKmzTabFilename(filename, new String[]{"Pistes_Cyclables"});
    }

    protected String getOverpassApiQueries(String bbox, String ... conditions) {
        return this.oaQuery(bbox, AbstractDataSetHandler.OaQueryType.NODE, conditions) + "\n" + this.oaRecurse(new AbstractDataSetHandler.OaRecurseType[]{AbstractDataSetHandler.OaRecurseType.NODE_RELATION, AbstractDataSetHandler.OaRecurseType.RELATION_WAY, AbstractDataSetHandler.OaRecurseType.WAY_NODE}) + "\n" + this.oaQuery(bbox, AbstractDataSetHandler.OaQueryType.WAY, conditions) + "\n" + this.oaRecurse(AbstractDataSetHandler.OaRecurseType.WAY_NODE, "nodes") + "\n" + this.oaRecurse(new AbstractDataSetHandler.OaRecurseType[]{AbstractDataSetHandler.OaRecurseType.WAY_RELATION});
    }

    private String applyHighwayTag(String name, IPrimitive p) {
        if (name != null && p != null) {
            for (String key : this.map.keySet()) {
                for (String value : this.map.get(key)) {
                    if (!name.startsWith(value)) continue;
                    p.put("highway", key);
                    return key;
                }
            }
        }
        return null;
    }

    public void updateDataSet(DataSet ds) {
        for (Way w : ds.getWays()) {
            String name;
            w.remove("name");
            String obs_type = w.get("obs_type");
            if (obs_type.equals("bande")) {
                w.put("cycleway", "lane");
            } else if (obs_type.equals("bande a contresens") || obs_type.equals("contre allee")) {
                w.put("cycleway", "opposite_lane");
            } else if (obs_type.equals("couloir bus")) {
                w.put("cycleway", "share_busway");
            } else if (obs_type.equals("trottoir")) {
                w.put("cycleway", "track");
            } else if (obs_type.equalsIgnoreCase("cheminement mixte") || obs_type.equals("reseau vert")) {
                w.put("highway", "cycleway");
                w.put("foot", "yes");
            } else if (obs_type.equals("piste") || obs_type.equals("voie verte")) {
                w.put("highway", "cycleway");
            } else if (obs_type.equals("zone 30")) {
                w.put("zone:maxspeed", "FR:30");
            } else {
                System.out.println(obs_type);
            }
            if ((name = w.get(this.streetField)) == null) continue;
            w.remove(this.streetField);
            if (w.get("highway") == null && this.applyHighwayTag(name, (IPrimitive)w) == null) {
                w.put("highway", "road");
            }
            w.put("name", name);
        }
    }
}

