/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.transport;

import java.io.File;
import java.net.URL;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class ReseauTisseoHandler
extends ToulouseDataSetHandler {
    public ReseauTisseoHandler() {
        super(14022, "network=fr_tisseo");
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsZipFilename(filename, new String[]{"14022-reseau-tisseo-metro-bus-tram-"}) || filename.toLowerCase().endsWith("xml");
    }

    public boolean acceptsFile(File file) {
        return this.acceptsFilename(file.getName()) && (file.getName().toLowerCase().endsWith("zip") || this.acceptsXmlNeptuneFile(file));
    }

    protected URL getNeptuneSchema() {
        return ReseauTisseoHandler.class.getResource("/neptune_toulouse/neptune.xsd");
    }

    @Override
    public String getSource() {
        return "Tiss\u00e9o SMTC";
    }

    public void updateDataSet(DataSet ds) {
        for (OsmPrimitive p : ds.allPrimitives()) {
            p.put("operator", "Tiss\u00e9o");
            p.put("network", "fr_tisseo");
        }
    }
}

