/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import javax.vecmath.Matrix3d;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.operation.Matrix;

public class Matrix3
extends Matrix3d
implements XMatrix {
    private static final long serialVersionUID = 8902061778871586611L;
    public static final int SIZE = 3;

    public Matrix3() {
        this.setIdentity();
    }

    public Matrix3(AffineTransform transform) {
        this.setMatrix(transform);
    }

    public Matrix3(Matrix matrix) {
        if (matrix.getNumRow() != 3 || matrix.getNumCol() != 3) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                this.setElement(j, i, matrix.getElement(j, i));
            }
        }
    }

    @Override
    public final int getNumRow() {
        return 3;
    }

    @Override
    public final int getNumCol() {
        return 3;
    }

    @Override
    public final boolean isIdentity() {
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                if (this.getElement(j, i) == (double)(i == j ? 1 : 0)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean isIdentity(double tolerance) {
        return GeneralMatrix.isIdentity(this, tolerance);
    }

    @Override
    public final boolean isAffine() {
        return this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0;
    }

    @Override
    public final void multiply(Matrix matrix) {
        Matrix3d m = matrix instanceof Matrix3d ? (Matrix3d)((Object)matrix) : new Matrix3(matrix);
        this.mul(m);
    }

    public void setMatrix(AffineTransform transform) {
        this.m00 = transform.getScaleX();
        this.m01 = transform.getShearX();
        this.m02 = transform.getTranslateX();
        this.m10 = transform.getShearY();
        this.m11 = transform.getScaleY();
        this.m12 = transform.getTranslateY();
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    @Override
    public boolean equals(Matrix matrix, double tolerance) {
        return GeneralMatrix.epsilonEquals(this, matrix, tolerance);
    }

    @Override
    public String toString() {
        return GeneralMatrix.toString(this);
    }

    @Override
    public Matrix3 clone() {
        return (Matrix3)super.clone();
    }
}

