/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;
import org.apache.poi.util.LittleEndianOutput;

public abstract class StandardRecord
extends Record {
    protected abstract int getDataSize();

    @Override
    public final int getRecordSize() {
        return 4 + this.getDataSize();
    }

    @Override
    public final int serialize(int n, byte[] byArray) {
        int n2 = this.getDataSize();
        int n3 = 4 + n2;
        LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream = new LittleEndianByteArrayOutputStream(byArray, n, n3);
        littleEndianByteArrayOutputStream.writeShort(this.getSid());
        littleEndianByteArrayOutputStream.writeShort(n2);
        this.serialize(littleEndianByteArrayOutputStream);
        if (littleEndianByteArrayOutputStream.getWriteIndex() - n != n3) {
            throw new IllegalStateException("Error in serialization of (" + this.getClass().getName() + "): " + "Incorrect number of bytes written - expected " + n3 + " but got " + (littleEndianByteArrayOutputStream.getWriteIndex() - n));
        }
        return n3;
    }

    protected abstract void serialize(LittleEndianOutput var1);
}

