/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.snap;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.overlay.snap.SnapTransformer;
import java.util.TreeSet;

public class GeometrySnapper {
    private static final double SNAP_PRECISION_FACTOR = 1.0E-9;
    private Geometry srcGeom;

    public static double computeOverlaySnapTolerance(Geometry geometry) {
        double d;
        double d2 = GeometrySnapper.computeSizeBasedSnapTolerance(geometry);
        PrecisionModel precisionModel = geometry.getPrecisionModel();
        if (precisionModel.getType() == PrecisionModel.FIXED && (d = 1.0 / precisionModel.getScale() * 2.0 / 1.415) > d2) {
            d2 = d;
        }
        return d2;
    }

    public static double computeSizeBasedSnapTolerance(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        double d = Math.min(envelope.getHeight(), envelope.getWidth());
        double d2 = d * 1.0E-9;
        return d2;
    }

    public static double computeOverlaySnapTolerance(Geometry geometry, Geometry geometry2) {
        return Math.min(GeometrySnapper.computeOverlaySnapTolerance(geometry), GeometrySnapper.computeOverlaySnapTolerance(geometry2));
    }

    public static Geometry[] snap(Geometry geometry, Geometry geometry2, double d) {
        Geometry[] geometryArray = new Geometry[2];
        GeometrySnapper geometrySnapper = new GeometrySnapper(geometry);
        geometryArray[0] = geometrySnapper.snapTo(geometry2, d);
        GeometrySnapper geometrySnapper2 = new GeometrySnapper(geometry2);
        geometryArray[1] = geometrySnapper2.snapTo(geometryArray[0], d);
        return geometryArray;
    }

    public GeometrySnapper(Geometry geometry) {
        this.srcGeom = geometry;
    }

    public Geometry snapTo(Geometry geometry, double d) {
        Coordinate[] coordinateArray = this.extractTargetCoordinates(geometry);
        SnapTransformer snapTransformer = new SnapTransformer(d, coordinateArray);
        return snapTransformer.transform(this.srcGeom);
    }

    public Coordinate[] extractTargetCoordinates(Geometry geometry) {
        TreeSet<Coordinate> treeSet = new TreeSet<Coordinate>();
        Coordinate[] coordinateArray = geometry.getCoordinates();
        for (int i = 0; i < coordinateArray.length; ++i) {
            treeSet.add(coordinateArray[i]);
        }
        return treeSet.toArray(new Coordinate[0]);
    }
}

