/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.PointExtracter;
import com.vividsolutions.jts.geom.util.PolygonExtracter;
import com.vividsolutions.jts.operation.distance.ConnectedElementLocationFilter;
import java.util.List;

public class DistanceOp {
    private Geometry[] geom;
    private double terminateDistance = 0.0;
    private PointLocator ptLocator = new PointLocator();
    private Coordinate[] minDistanceLocation;
    private double minDistance = Double.MAX_VALUE;

    public static boolean isWithinDistance(Geometry geometry, Geometry geometry2, double d) {
        DistanceOp distanceOp = new DistanceOp(geometry, geometry2, d);
        return distanceOp.distance() <= d;
    }

    public DistanceOp(Geometry geometry, Geometry geometry2, double d) {
        this.geom = new Geometry[2];
        this.geom[0] = geometry;
        this.geom[1] = geometry2;
        this.terminateDistance = d;
    }

    public double distance() {
        if (this.geom[0] == null || this.geom[1] == null) {
            throw new IllegalArgumentException("null geometries are not supported");
        }
        if (this.geom[0].isEmpty() || this.geom[1].isEmpty()) {
            return 0.0;
        }
        this.computeMinDistance();
        return this.minDistance;
    }

    private void updateMinDistance(Coordinate[] coordinateArray, boolean bl) {
        if (coordinateArray[0] == null) {
            return;
        }
        if (bl) {
            this.minDistanceLocation[0] = coordinateArray[1];
            this.minDistanceLocation[1] = coordinateArray[0];
        } else {
            this.minDistanceLocation[0] = coordinateArray[0];
            this.minDistanceLocation[1] = coordinateArray[1];
        }
    }

    private void computeMinDistance() {
        if (this.minDistanceLocation != null) {
            return;
        }
        this.minDistanceLocation = new Coordinate[2];
        this.computeContainmentDistance();
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        this.computeFacetDistance();
    }

    private void computeContainmentDistance() {
        Coordinate[] coordinateArray = new Coordinate[2];
        this.computeContainmentDistance(0, coordinateArray);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        this.computeContainmentDistance(1, coordinateArray);
    }

    private void computeContainmentDistance(int n, Coordinate[] coordinateArray) {
        int n2 = 1 - n;
        List list = PolygonExtracter.getPolygons(this.geom[n]);
        if (list.size() > 0) {
            List list2 = ConnectedElementLocationFilter.getLocations(this.geom[n2]);
            this.computeContainmentDistance(list2, list, coordinateArray);
            if (this.minDistance <= this.terminateDistance) {
                this.minDistanceLocation[n2] = coordinateArray[0];
                this.minDistanceLocation[n] = coordinateArray[1];
                return;
            }
        }
    }

    private void computeContainmentDistance(List list, List list2, Coordinate[] coordinateArray) {
        for (int i = 0; i < list.size(); ++i) {
            Coordinate coordinate = (Coordinate)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                this.computeContainmentDistance(coordinate, (Polygon)list2.get(j), coordinateArray);
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private void computeContainmentDistance(Coordinate coordinate, Polygon polygon, Coordinate[] coordinateArray) {
        Coordinate coordinate2 = coordinate;
        if (2 != this.ptLocator.locate(coordinate2, (Geometry)polygon)) {
            this.minDistance = 0.0;
            coordinateArray[0] = coordinate;
            coordinateArray[1] = new Coordinate(coordinate2);
            return;
        }
    }

    private void computeFacetDistance() {
        Coordinate[] coordinateArray = new Coordinate[2];
        List list = LinearComponentExtracter.getLines(this.geom[0]);
        List list2 = LinearComponentExtracter.getLines(this.geom[1]);
        List list3 = PointExtracter.getPoints(this.geom[0]);
        List list4 = PointExtracter.getPoints(this.geom[1]);
        this.computeMinDistanceLines(list, list2, coordinateArray);
        this.updateMinDistance(coordinateArray, false);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        coordinateArray[0] = null;
        coordinateArray[1] = null;
        this.computeMinDistanceLinesPoints(list, list4, coordinateArray);
        this.updateMinDistance(coordinateArray, false);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        coordinateArray[0] = null;
        coordinateArray[1] = null;
        this.computeMinDistanceLinesPoints(list2, list3, coordinateArray);
        this.updateMinDistance(coordinateArray, true);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        coordinateArray[0] = null;
        coordinateArray[1] = null;
        this.computeMinDistancePoints(list3, list4, coordinateArray);
        this.updateMinDistance(coordinateArray, false);
    }

    private void computeMinDistanceLines(List list, List list2, Coordinate[] coordinateArray) {
        for (int i = 0; i < list.size(); ++i) {
            LineString lineString = (LineString)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                LineString lineString2 = (LineString)list2.get(j);
                this.computeMinDistance(lineString, lineString2, coordinateArray);
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private void computeMinDistancePoints(List list, List list2, Coordinate[] coordinateArray) {
        for (int i = 0; i < list.size(); ++i) {
            Point point = (Point)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                Point point2 = (Point)list2.get(j);
                double d = point.getCoordinate().distance(point2.getCoordinate());
                if (d < this.minDistance) {
                    this.minDistance = d;
                    coordinateArray[0] = new Coordinate(point.getCoordinate());
                    coordinateArray[1] = new Coordinate(point2.getCoordinate());
                }
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private void computeMinDistanceLinesPoints(List list, List list2, Coordinate[] coordinateArray) {
        for (int i = 0; i < list.size(); ++i) {
            LineString lineString = (LineString)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                Point point = (Point)list2.get(j);
                this.computeMinDistance(lineString, point, coordinateArray);
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private void computeMinDistance(LineString lineString, LineString lineString2, Coordinate[] coordinateArray) {
        if (lineString.getEnvelopeInternal().distance(lineString2.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coordinateArray2 = lineString.getCoordinates();
        Coordinate[] coordinateArray3 = lineString2.getCoordinates();
        for (int i = 0; i < coordinateArray2.length - 1; ++i) {
            for (int j = 0; j < coordinateArray3.length - 1; ++j) {
                double d = CGAlgorithms.distanceLineLine(coordinateArray2[i], coordinateArray2[i + 1], coordinateArray3[j], coordinateArray3[j + 1]);
                if (d < this.minDistance) {
                    this.minDistance = d;
                    LineSegment lineSegment = new LineSegment(coordinateArray2[i], coordinateArray2[i + 1]);
                    LineSegment lineSegment2 = new LineSegment(coordinateArray3[j], coordinateArray3[j + 1]);
                    Coordinate[] coordinateArray4 = lineSegment.closestPoints(lineSegment2);
                    coordinateArray[0] = new Coordinate(coordinateArray4[0]);
                    coordinateArray[1] = new Coordinate(coordinateArray4[1]);
                }
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private void computeMinDistance(LineString lineString, Point point, Coordinate[] coordinateArray) {
        if (lineString.getEnvelopeInternal().distance(point.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coordinateArray2 = lineString.getCoordinates();
        Coordinate coordinate = point.getCoordinate();
        for (int i = 0; i < coordinateArray2.length - 1; ++i) {
            double d = CGAlgorithms.distancePointLine(coordinate, coordinateArray2[i], coordinateArray2[i + 1]);
            if (d < this.minDistance) {
                this.minDistance = d;
                LineSegment lineSegment = new LineSegment(coordinateArray2[i], coordinateArray2[i + 1]);
                Coordinate coordinate2 = lineSegment.closestPoint(coordinate);
                coordinateArray[0] = new Coordinate(coordinate2);
                coordinateArray[1] = new Coordinate(coordinate);
            }
            if (!(this.minDistance <= this.terminateDistance)) continue;
            return;
        }
    }
}

