/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryCollectionMapper;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.IsSimpleOp;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import com.vividsolutions.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import com.vividsolutions.jts.operation.predicate.RectangleContains;
import com.vividsolutions.jts.operation.predicate.RectangleIntersects;
import com.vividsolutions.jts.operation.relate.RelateOp;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public abstract class Geometry
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 8763622679187376702L;
    private static Class[] sortedClasses;
    private static final GeometryComponentFilter geometryChangedFilter;
    protected Envelope envelope;
    protected final GeometryFactory factory;
    private Object userData = null;

    public Geometry(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
    }

    public abstract String getGeometryType();

    protected static boolean hasNonEmptyElements(Geometry[] geometryArray) {
        for (int i = 0; i < geometryArray.length; ++i) {
            if (geometryArray[i].isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasNullElements(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            return true;
        }
        return false;
    }

    public GeometryFactory getFactory() {
        return this.factory;
    }

    public Object getUserData() {
        return this.userData;
    }

    public int getNumGeometries() {
        return 1;
    }

    public Geometry getGeometryN(int n) {
        return this;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public PrecisionModel getPrecisionModel() {
        return this.factory.getPrecisionModel();
    }

    public abstract Coordinate getCoordinate();

    public abstract Coordinate[] getCoordinates();

    public abstract int getNumPoints();

    public boolean isSimple() {
        this.checkNotGeometryCollection(this);
        IsSimpleOp isSimpleOp = new IsSimpleOp(this);
        return isSimpleOp.isSimple();
    }

    public boolean isValid() {
        return IsValidOp.isValid(this);
    }

    public abstract boolean isEmpty();

    public boolean isWithinDistance(Geometry geometry, double d) {
        double d2 = this.getEnvelopeInternal().distance(geometry.getEnvelopeInternal());
        if (d2 > d) {
            return false;
        }
        return DistanceOp.isWithinDistance(this, geometry, d);
    }

    public boolean isRectangle() {
        return false;
    }

    public double getArea() {
        return 0.0;
    }

    public double getLength() {
        return 0.0;
    }

    public abstract int getDimension();

    public abstract Geometry getBoundary();

    public abstract int getBoundaryDimension();

    public Envelope getEnvelopeInternal() {
        if (this.envelope == null) {
            this.envelope = this.computeEnvelopeInternal();
        }
        return this.envelope;
    }

    public void geometryChanged() {
        this.apply(geometryChangedFilter);
    }

    protected void geometryChangedAction() {
        this.envelope = null;
    }

    public boolean disjoint(Geometry geometry) {
        return !this.intersects(geometry);
    }

    public boolean touches(Geometry geometry) {
        if (!this.getEnvelopeInternal().intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(geometry).isTouches(this.getDimension(), geometry.getDimension());
    }

    public boolean intersects(Geometry geometry) {
        if (!this.getEnvelopeInternal().intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return RectangleIntersects.intersects((Polygon)this, geometry);
        }
        if (geometry.isRectangle()) {
            return RectangleIntersects.intersects((Polygon)geometry, this);
        }
        return this.relate(geometry).isIntersects();
    }

    public boolean crosses(Geometry geometry) {
        if (!this.getEnvelopeInternal().intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(geometry).isCrosses(this.getDimension(), geometry.getDimension());
    }

    public boolean within(Geometry geometry) {
        return geometry.contains(this);
    }

    public boolean contains(Geometry geometry) {
        if (!this.getEnvelopeInternal().contains(geometry.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return RectangleContains.contains((Polygon)this, geometry);
        }
        return this.relate(geometry).isContains();
    }

    public boolean overlaps(Geometry geometry) {
        if (!this.getEnvelopeInternal().intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(geometry).isOverlaps(this.getDimension(), geometry.getDimension());
    }

    public boolean covers(Geometry geometry) {
        if (!this.getEnvelopeInternal().covers(geometry.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return true;
        }
        return this.relate(geometry).isCovers();
    }

    public boolean relate(Geometry geometry, String string) {
        return this.relate(geometry).matches(string);
    }

    public IntersectionMatrix relate(Geometry geometry) {
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(geometry);
        return RelateOp.relate(this, geometry);
    }

    public boolean equals(Geometry geometry) {
        return this.equalsTopo(geometry);
    }

    public boolean equalsTopo(Geometry geometry) {
        if (!this.getEnvelopeInternal().equals(geometry.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(geometry).isEquals(this.getDimension(), geometry.getDimension());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Geometry)) {
            return false;
        }
        Geometry geometry = (Geometry)object;
        return this.equalsExact(geometry);
    }

    public int hashCode() {
        return this.getEnvelopeInternal().hashCode();
    }

    public String toString() {
        return this.toText();
    }

    public String toText() {
        WKTWriter wKTWriter = new WKTWriter();
        return wKTWriter.write(this);
    }

    public Geometry convexHull() {
        return new ConvexHull(this).getConvexHull();
    }

    public abstract Geometry reverse();

    public Geometry intersection(Geometry geometry) {
        if (this.isEmpty()) {
            return this.getFactory().createGeometryCollection(null);
        }
        if (geometry.isEmpty()) {
            return this.getFactory().createGeometryCollection(null);
        }
        if (this.isGeometryCollection(this)) {
            final Geometry geometry2 = geometry;
            return GeometryCollectionMapper.map((GeometryCollection)this, new GeometryCollectionMapper.MapOp(){

                @Override
                public Geometry map(Geometry geometry) {
                    return geometry.intersection(geometry2);
                }
            });
        }
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(geometry);
        return SnapIfNeededOverlayOp.overlayOp(this, geometry, 1);
    }

    public abstract boolean equalsExact(Geometry var1, double var2);

    public boolean equalsExact(Geometry geometry) {
        return this.equalsExact(geometry, 0.0);
    }

    public abstract void apply(CoordinateFilter var1);

    public abstract void apply(CoordinateSequenceFilter var1);

    public abstract void apply(GeometryFilter var1);

    public abstract void apply(GeometryComponentFilter var1);

    public Object clone() {
        try {
            Geometry geometry = (Geometry)super.clone();
            if (geometry.envelope != null) {
                geometry.envelope = new Envelope(geometry.envelope);
            }
            return geometry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public abstract void normalize();

    public int compareTo(Object object) {
        Geometry geometry = (Geometry)object;
        if (this.getClassSortIndex() != geometry.getClassSortIndex()) {
            return this.getClassSortIndex() - geometry.getClassSortIndex();
        }
        if (this.isEmpty() && geometry.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (geometry.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(object);
    }

    protected boolean isEquivalentClass(Geometry geometry) {
        return this.getClass().getName().equals(geometry.getClass().getName());
    }

    protected void checkNotGeometryCollection(Geometry geometry) {
        if (geometry.getClass().getName().equals("com.vividsolutions.jts.geom.GeometryCollection")) {
            throw new IllegalArgumentException("This method does not support GeometryCollection arguments");
        }
    }

    protected boolean isGeometryCollection(Geometry geometry) {
        return geometry.getClass().equals(GeometryCollection.class);
    }

    protected abstract Envelope computeEnvelopeInternal();

    protected abstract int compareToSameClass(Object var1);

    protected abstract int compareToSameClass(Object var1, CoordinateSequenceComparator var2);

    protected int compare(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Comparable comparable;
            Comparable comparable2 = (Comparable)iterator.next();
            int n = comparable2.compareTo(comparable = (Comparable)iterator2.next());
            if (n == 0) continue;
            return n;
        }
        if (iterator.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    protected boolean equal(Coordinate coordinate, Coordinate coordinate2, double d) {
        if (d == 0.0) {
            return coordinate.equals(coordinate2);
        }
        return coordinate.distance(coordinate2) <= d;
    }

    private int getClassSortIndex() {
        if (sortedClasses == null) {
            Geometry.initSortedClasses();
        }
        for (int i = 0; i < sortedClasses.length; ++i) {
            if (!sortedClasses[i].isInstance(this)) continue;
            return i;
        }
        Assert.shouldNeverReachHere("Class not supported: " + this.getClass());
        return -1;
    }

    private static void initSortedClasses() {
        sortedClasses = new Class[]{Point.class, MultiPoint.class, LineString.class, LinearRing.class, MultiLineString.class, Polygon.class, MultiPolygon.class, GeometryCollection.class};
    }

    private Point createPointFromInternalCoord(Coordinate coordinate, Geometry geometry) {
        geometry.getPrecisionModel().makePrecise(coordinate);
        return geometry.getFactory().createPoint(coordinate);
    }

    static {
        geometryChangedFilter = new GeometryComponentFilter(){

            @Override
            public void filter(Geometry geometry) {
                geometry.geometryChangedAction();
            }
        };
    }
}

