/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;

public class CGAlgorithms {
    public static final int CLOCKWISE = -1;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int COLLINEAR = 0;

    public static int orientationIndex(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate2.x - coordinate.x;
        double d2 = coordinate2.y - coordinate.y;
        double d3 = coordinate3.x - coordinate2.x;
        double d4 = coordinate3.y - coordinate2.y;
        return RobustDeterminant.signOfDet2x2(d, d2, d3, d4);
    }

    public static boolean isPointInRing(Coordinate coordinate, Coordinate[] coordinateArray) {
        return CGAlgorithms.locatePointInRing(coordinate, coordinateArray) != 2;
    }

    public static int locatePointInRing(Coordinate coordinate, Coordinate[] coordinateArray) {
        return RayCrossingCounter.locatePointInRing(coordinate, coordinateArray);
    }

    public static boolean isOnLine(Coordinate coordinate, Coordinate[] coordinateArray) {
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        for (int i = 1; i < coordinateArray.length; ++i) {
            Coordinate coordinate2 = coordinateArray[i - 1];
            Coordinate coordinate3 = coordinateArray[i];
            ((LineIntersector)robustLineIntersector).computeIntersection(coordinate, coordinate2, coordinate3);
            if (!robustLineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    public static boolean isCCW(Coordinate[] coordinateArray) {
        int n;
        int n2 = coordinateArray.length - 1;
        if (n2 < 3) {
            throw new IllegalArgumentException("Ring has fewer than 3 points, so orientation cannot be determined");
        }
        Coordinate coordinate = coordinateArray[0];
        int n3 = 0;
        for (n = 1; n <= n2; ++n) {
            Coordinate coordinate2 = coordinateArray[n];
            if (!(coordinate2.y > coordinate.y)) continue;
            coordinate = coordinate2;
            n3 = n;
        }
        n = n3;
        do {
            if (--n >= 0) continue;
            n = n2;
        } while (coordinateArray[n].equals2D(coordinate) && n != n3);
        int n4 = n3;
        while (coordinateArray[n4 = (n4 + 1) % n2].equals2D(coordinate) && n4 != n3) {
        }
        Coordinate coordinate3 = coordinateArray[n];
        Coordinate coordinate4 = coordinateArray[n4];
        if (coordinate3.equals2D(coordinate) || coordinate4.equals2D(coordinate) || coordinate3.equals2D(coordinate4)) {
            return false;
        }
        int n5 = CGAlgorithms.computeOrientation(coordinate3, coordinate, coordinate4);
        boolean bl = false;
        bl = n5 == 0 ? coordinate3.x > coordinate4.x : n5 > 0;
        return bl;
    }

    public static int computeOrientation(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return CGAlgorithms.orientationIndex(coordinate, coordinate2, coordinate3);
    }

    public static double distancePointLine(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        if (coordinate2.x == coordinate3.x && coordinate2.y == coordinate3.y) {
            return coordinate.distance(coordinate2);
        }
        double d = ((coordinate.x - coordinate2.x) * (coordinate3.x - coordinate2.x) + (coordinate.y - coordinate2.y) * (coordinate3.y - coordinate2.y)) / ((coordinate3.x - coordinate2.x) * (coordinate3.x - coordinate2.x) + (coordinate3.y - coordinate2.y) * (coordinate3.y - coordinate2.y));
        if (d <= 0.0) {
            return coordinate.distance(coordinate2);
        }
        if (d >= 1.0) {
            return coordinate.distance(coordinate3);
        }
        double d2 = ((coordinate2.y - coordinate.y) * (coordinate3.x - coordinate2.x) - (coordinate2.x - coordinate.x) * (coordinate3.y - coordinate2.y)) / ((coordinate3.x - coordinate2.x) * (coordinate3.x - coordinate2.x) + (coordinate3.y - coordinate2.y) * (coordinate3.y - coordinate2.y));
        return Math.abs(d2) * Math.sqrt((coordinate3.x - coordinate2.x) * (coordinate3.x - coordinate2.x) + (coordinate3.y - coordinate2.y) * (coordinate3.y - coordinate2.y));
    }

    public static double distanceLineLine(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        if (coordinate.equals(coordinate2)) {
            return CGAlgorithms.distancePointLine(coordinate, coordinate3, coordinate4);
        }
        if (coordinate3.equals(coordinate4)) {
            return CGAlgorithms.distancePointLine(coordinate4, coordinate, coordinate2);
        }
        double d = (coordinate.y - coordinate3.y) * (coordinate4.x - coordinate3.x) - (coordinate.x - coordinate3.x) * (coordinate4.y - coordinate3.y);
        double d2 = (coordinate2.x - coordinate.x) * (coordinate4.y - coordinate3.y) - (coordinate2.y - coordinate.y) * (coordinate4.x - coordinate3.x);
        double d3 = (coordinate.y - coordinate3.y) * (coordinate2.x - coordinate.x) - (coordinate.x - coordinate3.x) * (coordinate2.y - coordinate.y);
        double d4 = (coordinate2.x - coordinate.x) * (coordinate4.y - coordinate3.y) - (coordinate2.y - coordinate.y) * (coordinate4.x - coordinate3.x);
        if (d2 == 0.0 || d4 == 0.0) {
            return Math.min(CGAlgorithms.distancePointLine(coordinate, coordinate3, coordinate4), Math.min(CGAlgorithms.distancePointLine(coordinate2, coordinate3, coordinate4), Math.min(CGAlgorithms.distancePointLine(coordinate3, coordinate, coordinate2), CGAlgorithms.distancePointLine(coordinate4, coordinate, coordinate2))));
        }
        double d5 = d3 / d4;
        double d6 = d / d2;
        if (d6 < 0.0 || d6 > 1.0 || d5 < 0.0 || d5 > 1.0) {
            return Math.min(CGAlgorithms.distancePointLine(coordinate, coordinate3, coordinate4), Math.min(CGAlgorithms.distancePointLine(coordinate2, coordinate3, coordinate4), Math.min(CGAlgorithms.distancePointLine(coordinate3, coordinate, coordinate2), CGAlgorithms.distancePointLine(coordinate4, coordinate, coordinate2))));
        }
        return 0.0;
    }

    public static double signedArea(CoordinateSequence coordinateSequence) {
        int n = coordinateSequence.size();
        if (n < 3) {
            return 0.0;
        }
        double d = 0.0;
        Coordinate coordinate = new Coordinate();
        coordinateSequence.getCoordinate(0, coordinate);
        double d2 = coordinate.x;
        double d3 = coordinate.y;
        for (int i = 1; i < n; ++i) {
            coordinateSequence.getCoordinate(i, coordinate);
            double d4 = coordinate.x;
            double d5 = coordinate.y;
            d += (d2 + d4) * (d5 - d3);
            d2 = d4;
            d3 = d5;
        }
        return -d / 2.0;
    }

    public static double length(CoordinateSequence coordinateSequence) {
        int n = coordinateSequence.size();
        if (n <= 1) {
            return 0.0;
        }
        double d = 0.0;
        Coordinate coordinate = new Coordinate();
        coordinateSequence.getCoordinate(0, coordinate);
        double d2 = coordinate.x;
        double d3 = coordinate.y;
        for (int i = 1; i < n; ++i) {
            coordinateSequence.getCoordinate(i, coordinate);
            double d4 = coordinate.x;
            double d5 = coordinate.y;
            double d6 = d4 - d2;
            double d7 = d5 - d3;
            d += Math.sqrt(d6 * d6 + d7 * d7);
            d2 = d4;
            d3 = d5;
        }
        return d;
    }
}

