/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets;

import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.ToulouseConstants;

public abstract class ToulouseDataSetHandler
extends FrenchDataSetHandler
implements ToulouseConstants {
    private int portalId;
    private String wikiPage;

    public ToulouseDataSetHandler(int portalId) {
        this.init(portalId);
    }

    public ToulouseDataSetHandler(int portalId, String relevantTag) {
        super(relevantTag);
        this.init(portalId);
    }

    public ToulouseDataSetHandler(int portalId, boolean relevantUnion, String ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(portalId);
    }

    public ToulouseDataSetHandler(int portalId, String ... relevantTags) {
        this(portalId, false, relevantTags);
    }

    public ToulouseDataSetHandler(int portalId, boolean relevantUnion, Tag ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(portalId);
    }

    private final void init(int portalId) {
        this.portalId = portalId;
    }

    public String getSource() {
        return "GrandToulouse";
    }

    public String getLocalPortalIconName() {
        return "data.fr.toulouse_24.png";
    }

    public String getDataLayerIconName() {
        return "data.fr.toulouse_16.png";
    }

    public final URL getLocalPortalURL() {
        try {
            if (this.portalId > 0) {
                return new URL("http://data.grandtoulouse.fr/les-donnees/-/opendata/card/" + this.portalId + "--");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public URL getWikiURL() {
        try {
            if (this.wikiPage != null && !this.wikiPage.isEmpty()) {
                return new URL("http://wiki.openstreetmap.org/wiki/Toulouse/GrandToulouseData/" + this.wikiPage);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected final void setWikiPage(String wikiPage) {
        this.wikiPage = wikiPage;
    }
}

