/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.layers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.actions.OpenLinkAction;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.OsmDownloader;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdDiffLayer;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdLayer;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdOsmDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class OdDataLayer
extends OsmDataLayer
implements OdConstants,
OdLayer,
MapView.LayerChangeListener {
    public OdDiffLayer diffLayer;
    public OdOsmDataLayer osmLayer;
    public final AbstractDataSetHandler handler;
    private Bounds bounds;

    public OdDataLayer(DataSet data, String name, File associatedFile, AbstractDataSetHandler handler) {
        super(data, name, associatedFile);
        this.setUploadDiscouraged(true);
        this.handler = handler;
        for (Node node : data.getNodes()) {
            if (this.bounds == null) {
                this.bounds = new Bounds(node.getCoor());
                continue;
            }
            this.bounds.extend(node.getCoor());
        }
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
    }

    public Icon getBaseIcon() {
        return new ImageProvider(this.handler != null ? this.handler.getDataLayerIconName() : "o16.png").setAdditionalClassLoaders(ModuleHandler.getResourceClassLoaders()).get();
    }

    public void addOsmLayer(OdOsmDataLayer layer) {
        this.removeOsmLayer();
        this.osmLayer = layer;
        Main.main.addLayer((Layer)this.osmLayer);
    }

    public void removeOsmLayer() {
        if (this.osmLayer != null) {
            Main.main.removeLayer((Layer)this.osmLayer);
            this.osmLayer = null;
        }
    }

    public void addDiffLayer(OdDiffLayer layer) {
        this.removeDiffLayer();
        this.diffLayer = layer;
        Main.main.addLayer((Layer)this.diffLayer);
    }

    public void removeDiffLayer() {
        if (this.diffLayer != null) {
            Main.main.removeLayer((Layer)this.diffLayer);
            this.diffLayer = null;
        }
    }

    public final void downloadOsmData() {
        String oapiReq = this.handler.getOverpassApiRequest(this.bounds);
        Collection<String> xapiReqs = this.handler.getOsmXapiRequests(this.bounds);
        if (oapiReq != null || xapiReqs != null) {
            DataSet dataSet = new DataSet();
            OdOsmDataLayer layer = new OdOsmDataLayer(this, dataSet, this.getName() + "/OSM");
            this.addOsmLayer(layer);
            Main.map.mapView.setActiveLayer((Layer)this.osmLayer);
            if (oapiReq != null) {
                OsmDownloader.downloadOapi(oapiReq);
                layer.removeForbiddenTags();
            } else {
                OsmDownloader.downloadXapi(xapiReqs);
            }
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == this) {
            this.removeOsmLayer();
            this.removeDiffLayer();
        } else if (oldLayer == this.osmLayer) {
            this.osmLayer = null;
        } else if (oldLayer == this.diffLayer) {
            this.diffLayer = null;
        }
    }

    public Action[] getMenuEntries() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Action entry : super.getMenuEntries()) {
            result.add(entry);
        }
        if (this.handler.getWikiURL() != null || this.handler.getLocalPortalURL() != null || this.handler.getNationalPortalURL() != null) {
            result.add(Layer.SeparatorLayerAction.INSTANCE);
        }
        if (this.handler.getWikiURL() != null) {
            result.add(new OpenLinkAction(this.handler.getWikiURL(), "osm24.png", I18n.tr((String)"View OSM Wiki page", (Object[])new Object[0]), I18n.tr((String)"Launch browser to the OSM Wiki page of the selected data set", (Object[])new Object[0])));
        }
        if (this.handler.getLocalPortalURL() != null) {
            result.add(new OpenLinkAction(this.handler.getLocalPortalURL(), this.handler.getLocalPortalIconName(), I18n.tr((String)"View Local Portal page", (Object[])new Object[0]), I18n.tr((String)"Launch browser to the local portal page of the selected data set", (Object[])new Object[0])));
        }
        if (this.handler.getNationalPortalURL() != null) {
            result.add(new OpenLinkAction(this.handler.getNationalPortalURL(), this.handler.getNationalPortalIconName(), I18n.tr((String)"View National Portal page", (Object[])new Object[0]), I18n.tr((String)"Launch browser to the national portal page of the selected data set", (Object[])new Object[0])));
        }
        return result.toArray(new Action[0]);
    }

    @Override
    public OdDataLayer getDataLayer() {
        return this;
    }

    public void makeDiff() {
        OdDiffLayer layer = new OdDiffLayer(this, this.getName() + "/Diff");
        this.addDiffLayer(layer);
        Main.map.mapView.setActiveLayer((Layer)this.diffLayer);
    }
}

