/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.tabular;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetReader;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;

public class CsvReader
extends SpreadSheetReader {
    private final Charset charset;
    private final String sep;
    private BufferedReader reader;
    private String line;

    public CsvReader(AbstractDataSetHandler handler) {
        super(handler);
        this.charset = handler != null && handler.getCsvCharset() != null ? handler.getCsvCharset() : Charset.forName("UTF-8");
        this.sep = handler != null && handler.getCsvSeparator() != null ? handler.getCsvSeparator() : ";";
    }

    public static DataSet parseDataSet(InputStream in, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        return new CsvReader(handler).parse(in, instance);
    }

    @Override
    protected void initResources(InputStream in, ProgressMonitor progressMonitor) throws IOException {
        System.out.println("Parsing CSV file using charset " + this.charset + " and separator '" + this.sep + "'");
        this.reader = new BufferedReader(new InputStreamReader(in, this.charset));
    }

    @Override
    protected String[] readLine(ProgressMonitor progressMonitor) throws IOException {
        this.line = this.reader.readLine();
        if (this.line != null) {
            return OdUtils.stripQuotes(this.line.split(this.sep), this.sep);
        }
        return null;
    }
}

