/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

import java.util.regex.Pattern;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;

public class ProjectionPatterns
implements OdConstants {
    private final Pattern xPattern;
    private final Pattern yPattern;
    private final Projection projection;

    public ProjectionPatterns(Pattern xPattern, Pattern yPattern, Projection projection) {
        this.xPattern = xPattern;
        this.yPattern = yPattern;
        this.projection = projection;
        PROJECTIONS.add(this);
    }

    public ProjectionPatterns(Pattern xPattern, Pattern yPattern) {
        this(xPattern, yPattern, null);
    }

    public ProjectionPatterns(String proj, Projection projection) {
        this(ProjectionPatterns.getCoordinatePattern("X|LON|LONGI|LONGITUDE", proj), ProjectionPatterns.getCoordinatePattern("Y|LAT|LATI|LATITUDE", proj), projection);
    }

    public ProjectionPatterns(String proj) {
        this(ProjectionPatterns.getCoordinatePattern("X|LON|LONGI|LONGITUDE", proj), ProjectionPatterns.getCoordinatePattern("Y|LAT|LATI|LATITUDE", proj), null);
    }

    public final Pattern getXPattern() {
        return this.xPattern;
    }

    public final Pattern getYPattern() {
        return this.yPattern;
    }

    public Projection getProjection(String xFieldName, String yFieldName) {
        return this.getProjection();
    }

    public final Projection getProjection() {
        return this.projection;
    }

    public static final Pattern getCoordinatePattern(String coor, String proj) {
        return Pattern.compile("(?:.*(?:" + coor + ").*(?:" + proj + ").*)|(?:.*(" + proj + ").*(?:" + coor + ").*)", 2);
    }
}

