/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.geomgraph.index.EdgeSetIntersector;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.geomgraph.index.SimpleMCSweepLineIntersector;
import com.vividsolutions.jts.util.Assert;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GeometryGraph
extends PlanarGraph {
    private Geometry parentGeom;
    private Map lineEdgeMap = new HashMap();
    private BoundaryNodeRule boundaryNodeRule = null;
    private boolean useBoundaryDeterminationRule = true;
    private int argIndex;
    private Collection boundaryNodes;
    private boolean hasTooFewPoints = false;
    private Coordinate invalidPoint = null;

    public static int determineBoundary(BoundaryNodeRule boundaryNodeRule, int n) {
        return boundaryNodeRule.isInBoundary(n) ? 1 : 0;
    }

    private EdgeSetIntersector createEdgeSetIntersector() {
        return new SimpleMCSweepLineIntersector();
    }

    public GeometryGraph(int n, Geometry geometry) {
        this(n, geometry, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE);
    }

    public GeometryGraph(int n, Geometry geometry, BoundaryNodeRule boundaryNodeRule) {
        this.argIndex = n;
        this.parentGeom = geometry;
        this.boundaryNodeRule = boundaryNodeRule;
        if (geometry != null) {
            this.add(geometry);
        }
    }

    public boolean hasTooFewPoints() {
        return this.hasTooFewPoints;
    }

    public Coordinate getInvalidPoint() {
        return this.invalidPoint;
    }

    public Geometry getGeometry() {
        return this.parentGeom;
    }

    public BoundaryNodeRule getBoundaryNodeRule() {
        return this.boundaryNodeRule;
    }

    public Collection getBoundaryNodes() {
        if (this.boundaryNodes == null) {
            this.boundaryNodes = this.nodes.getBoundaryNodes(this.argIndex);
        }
        return this.boundaryNodes;
    }

    public Edge findEdge(LineString lineString) {
        return (Edge)this.lineEdgeMap.get(lineString);
    }

    public void computeSplitEdges(List list) {
        for (Edge edge : this.edges) {
            edge.eiList.addSplitEdges(list);
        }
    }

    private void add(Geometry geometry) {
        if (geometry.isEmpty()) {
            return;
        }
        if (geometry instanceof MultiPolygon) {
            this.useBoundaryDeterminationRule = false;
        }
        if (geometry instanceof Polygon) {
            this.addPolygon((Polygon)geometry);
        } else if (geometry instanceof LineString) {
            this.addLineString((LineString)geometry);
        } else if (geometry instanceof Point) {
            this.addPoint((Point)geometry);
        } else if (geometry instanceof MultiPoint) {
            this.addCollection((MultiPoint)geometry);
        } else if (geometry instanceof MultiLineString) {
            this.addCollection((MultiLineString)geometry);
        } else if (geometry instanceof MultiPolygon) {
            this.addCollection((MultiPolygon)geometry);
        } else if (geometry instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)geometry);
        } else {
            throw new UnsupportedOperationException(geometry.getClass().getName());
        }
    }

    private void addCollection(GeometryCollection geometryCollection) {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry = geometryCollection.getGeometryN(i);
            this.add(geometry);
        }
    }

    private void addPoint(Point point) {
        Coordinate coordinate = point.getCoordinate();
        this.insertPoint(this.argIndex, coordinate, 0);
    }

    private void addPolygonRing(LinearRing linearRing, int n, int n2) {
        if (linearRing.isEmpty()) {
            return;
        }
        Coordinate[] coordinateArray = CoordinateArrays.removeRepeatedPoints(linearRing.getCoordinates());
        if (coordinateArray.length < 4) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coordinateArray[0];
            return;
        }
        int n3 = n;
        int n4 = n2;
        if (CGAlgorithms.isCCW(coordinateArray)) {
            n3 = n2;
            n4 = n;
        }
        Edge edge = new Edge(coordinateArray, new Label(this.argIndex, 1, n3, n4));
        this.lineEdgeMap.put(linearRing, edge);
        this.insertEdge(edge);
        this.insertPoint(this.argIndex, coordinateArray[0], 1);
    }

    private void addPolygon(Polygon polygon) {
        this.addPolygonRing((LinearRing)polygon.getExteriorRing(), 2, 0);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing linearRing = (LinearRing)polygon.getInteriorRingN(i);
            this.addPolygonRing(linearRing, 0, 2);
        }
    }

    private void addLineString(LineString lineString) {
        Coordinate[] coordinateArray = CoordinateArrays.removeRepeatedPoints(lineString.getCoordinates());
        if (coordinateArray.length < 2) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coordinateArray[0];
            return;
        }
        Edge edge = new Edge(coordinateArray, new Label(this.argIndex, 0));
        this.lineEdgeMap.put(lineString, edge);
        this.insertEdge(edge);
        Assert.isTrue(coordinateArray.length >= 2, "found LineString with single point");
        this.insertBoundaryPoint(this.argIndex, coordinateArray[0]);
        this.insertBoundaryPoint(this.argIndex, coordinateArray[coordinateArray.length - 1]);
    }

    public SegmentIntersector computeSelfNodes(LineIntersector lineIntersector, boolean bl) {
        SegmentIntersector segmentIntersector = new SegmentIntersector(lineIntersector, true, false);
        EdgeSetIntersector edgeSetIntersector = this.createEdgeSetIntersector();
        if (!bl && (this.parentGeom instanceof LinearRing || this.parentGeom instanceof Polygon || this.parentGeom instanceof MultiPolygon)) {
            edgeSetIntersector.computeIntersections(this.edges, segmentIntersector, false);
        } else {
            edgeSetIntersector.computeIntersections(this.edges, segmentIntersector, true);
        }
        this.addSelfIntersectionNodes(this.argIndex);
        return segmentIntersector;
    }

    public SegmentIntersector computeEdgeIntersections(GeometryGraph geometryGraph, LineIntersector lineIntersector, boolean bl) {
        SegmentIntersector segmentIntersector = new SegmentIntersector(lineIntersector, bl, true);
        segmentIntersector.setBoundaryNodes(this.getBoundaryNodes(), geometryGraph.getBoundaryNodes());
        EdgeSetIntersector edgeSetIntersector = this.createEdgeSetIntersector();
        edgeSetIntersector.computeIntersections(this.edges, geometryGraph.edges, segmentIntersector);
        return segmentIntersector;
    }

    private void insertPoint(int n, Coordinate coordinate, int n2) {
        Node node = this.nodes.addNode(coordinate);
        Label label = node.getLabel();
        if (label == null) {
            node.label = new Label(n, n2);
        } else {
            label.setLocation(n, n2);
        }
    }

    private void insertBoundaryPoint(int n, Coordinate coordinate) {
        Node node = this.nodes.addNode(coordinate);
        Label label = node.getLabel();
        int n2 = 1;
        int n3 = -1;
        if (label != null) {
            n3 = label.getLocation(n, 0);
        }
        if (n3 == 1) {
            ++n2;
        }
        int n4 = GeometryGraph.determineBoundary(this.boundaryNodeRule, n2);
        label.setLocation(n, n4);
    }

    private void addSelfIntersectionNodes(int n) {
        for (Edge edge : this.edges) {
            int n2 = edge.getLabel().getLocation(n);
            Iterator iterator = edge.eiList.iterator();
            while (iterator.hasNext()) {
                EdgeIntersection edgeIntersection = (EdgeIntersection)iterator.next();
                this.addSelfIntersectionNode(n, edgeIntersection.coord, n2);
            }
        }
    }

    private void addSelfIntersectionNode(int n, Coordinate coordinate, int n2) {
        if (this.isBoundaryNode(n, coordinate)) {
            return;
        }
        if (n2 == 1 && this.useBoundaryDeterminationRule) {
            this.insertBoundaryPoint(n, coordinate);
        } else {
            this.insertPoint(n, coordinate, n2);
        }
    }
}

