/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import java.util.Vector;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.tools.I18n;
import public_transport.StopImporterAction;
import public_transport.WaypointTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaypointsDisableCommand
extends Command {
    private Vector<Integer> workingLines = null;
    private Vector<Node> nodesForUndo = null;
    private WaypointTableModel waypointTM = null;

    public WaypointsDisableCommand(StopImporterAction controller) {
        int i;
        this.waypointTM = controller.getWaypointTableModel();
        this.workingLines = new Vector();
        this.nodesForUndo = new Vector();
        int[] selectedLines = controller.getDialog().getWaypointsTable().getSelectedRows();
        Vector<Integer> consideredLines = new Vector<Integer>();
        if (selectedLines.length > 0) {
            for (i = 0; i < selectedLines.length; ++i) {
                consideredLines.add(selectedLines[i]);
            }
        } else {
            for (i = 0; i < this.waypointTM.getRowCount(); ++i) {
                consideredLines.add(new Integer(i));
            }
        }
        for (i = 0; i < consideredLines.size(); ++i) {
            if (this.waypointTM.nodes.elementAt((Integer)consideredLines.elementAt(i)) == null) continue;
            this.workingLines.add((Integer)consideredLines.elementAt(i));
        }
    }

    public boolean executeCommand() {
        this.nodesForUndo.clear();
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            Node node = this.waypointTM.nodes.elementAt(j);
            this.nodesForUndo.add(node);
            if (node == null) continue;
            this.waypointTM.nodes.set(j, null);
            Main.main.getCurrentDataSet().removePrimitive((PrimitiveId)node);
            node.setDeleted(true);
        }
        return true;
    }

    public void undoCommand() {
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            Node node = this.nodesForUndo.elementAt(i);
            this.waypointTM.nodes.set(j, node);
            if (node == null) continue;
            node.setDeleted(false);
            Main.main.getCurrentDataSet().addPrimitive((OsmPrimitive)node);
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Disable waypoints", (Object[])new Object[0]);
    }
}

