/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleException;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;

public class ModulePreferencesModel
extends Observable
implements OdConstants {
    private final ArrayList<ModuleInformation> availableModules = new ArrayList();
    private final ArrayList<ModuleInformation> displayedModules = new ArrayList();
    private final HashMap<ModuleInformation, Boolean> selectedModulesMap = new HashMap();
    private Set<String> pendingDownloads = new HashSet<String>();
    private String filterExpression;
    private final Set<String> currentActiveModules = new HashSet<String>();

    protected Collection<String> getModules(Collection<String> def) {
        return Main.pref.getCollection("opendata.modules", def);
    }

    public ModulePreferencesModel() {
        this.currentActiveModules.addAll(this.getModules(this.currentActiveModules));
    }

    public void filterDisplayedModules(String filter) {
        if (filter == null) {
            this.displayedModules.clear();
            this.displayedModules.addAll(this.availableModules);
            this.filterExpression = null;
            return;
        }
        this.displayedModules.clear();
        for (ModuleInformation pi : this.availableModules) {
            if (!pi.matches(filter)) continue;
            this.displayedModules.add(pi);
        }
        this.filterExpression = filter;
        this.clearChanged();
        this.notifyObservers();
    }

    public void setAvailableModules(Collection<ModuleInformation> available) {
        this.availableModules.clear();
        if (available != null) {
            this.availableModules.addAll(available);
        }
        this.sort();
        this.filterDisplayedModules(this.filterExpression);
        HashSet<String> activeModules = new HashSet<String>();
        activeModules.addAll(this.getModules(activeModules));
        for (ModuleInformation pi : this.availableModules) {
            if (this.selectedModulesMap.get(pi) != null || !activeModules.contains(pi.name)) continue;
            this.selectedModulesMap.put(pi, true);
        }
        this.clearChanged();
        this.notifyObservers();
    }

    protected void updateAvailableModule(ModuleInformation other) {
        if (other == null) {
            return;
        }
        ModuleInformation pi = this.getModuleInformation(other.name);
        if (pi == null) {
            this.availableModules.add(other);
            return;
        }
        pi.updateFromModuleSite(other);
    }

    public void updateAvailableModules(Collection<ModuleInformation> fromModuleSite) {
        for (ModuleInformation other : fromModuleSite) {
            this.updateAvailableModule(other);
        }
        this.sort();
        this.filterDisplayedModules(this.filterExpression);
        HashSet<String> activeModules = new HashSet<String>();
        activeModules.addAll(this.getModules(activeModules));
        for (ModuleInformation pi : this.availableModules) {
            if (this.selectedModulesMap.get(pi) != null || !activeModules.contains(pi.name)) continue;
            this.selectedModulesMap.put(pi, true);
        }
        this.clearChanged();
        this.notifyObservers();
    }

    public List<ModuleInformation> getSelectedModules() {
        LinkedList<ModuleInformation> ret = new LinkedList<ModuleInformation>();
        for (ModuleInformation pi : this.availableModules) {
            if (this.selectedModulesMap.get(pi) == null || !this.selectedModulesMap.get(pi).booleanValue()) continue;
            ret.add(pi);
        }
        return ret;
    }

    public Set<String> getSelectedModuleNames() {
        HashSet<String> ret = new HashSet<String>();
        for (ModuleInformation pi : this.getSelectedModules()) {
            ret.add(pi.name);
        }
        return ret;
    }

    protected void sort() {
        Collections.sort(this.availableModules, new Comparator<ModuleInformation>(){

            @Override
            public int compare(ModuleInformation o1, ModuleInformation o2) {
                String n1 = o1.getName() == null ? "" : o1.getName().toLowerCase();
                String n2 = o2.getName() == null ? "" : o2.getName().toLowerCase();
                return n1.compareTo(n2);
            }
        });
    }

    public List<ModuleInformation> getDisplayedModules() {
        return this.displayedModules;
    }

    public void setModuleSelected(String name, boolean selected) {
        ModuleInformation pi = this.getModuleInformation(name);
        if (pi != null) {
            this.selectedModulesMap.put(pi, selected);
            if (pi.isUpdateRequired()) {
                this.pendingDownloads.add(pi.name);
            }
        }
        if (!selected) {
            this.pendingDownloads.remove(name);
        }
    }

    public void clearPendingModules(Collection<ModuleInformation> modules) {
        if (modules == null || modules.isEmpty()) {
            return;
        }
        for (ModuleInformation pi : modules) {
            this.pendingDownloads.remove(pi.name);
        }
    }

    public ModuleInformation getModuleInformation(String name) {
        for (ModuleInformation pi : this.availableModules) {
            if (pi.getName() == null || !pi.getName().equals(name)) continue;
            return pi;
        }
        return null;
    }

    public boolean isSelectedModule(String name) {
        ModuleInformation pi = this.getModuleInformation(name);
        if (pi == null) {
            return false;
        }
        if (this.selectedModulesMap.get(pi) == null) {
            return false;
        }
        return this.selectedModulesMap.get(pi);
    }

    public boolean isActiveModulesChanged() {
        Set<String> newActiveModules = this.getSelectedModuleNames();
        return !((Object)newActiveModules).equals(this.currentActiveModules);
    }

    public void refreshLocalModuleVersion(Collection<ModuleInformation> modules) {
        if (modules == null) {
            return;
        }
        File moduleDir = OdPlugin.getInstance().getModulesDirectory();
        for (ModuleInformation pi : modules) {
            File downloadedModuleFile = new File(moduleDir, pi.name + ".jar.new");
            if (!(downloadedModuleFile.exists() && downloadedModuleFile.canRead() || (downloadedModuleFile = new File(moduleDir, pi.name + ".jar")).exists() && downloadedModuleFile.canRead())) continue;
            try {
                ModuleInformation newinfo = new ModuleInformation(downloadedModuleFile, pi.name);
                ModuleInformation oldinfo = this.getModuleInformation(pi.name);
                if (oldinfo == null) continue;
                oldinfo.localversion = newinfo.version;
            }
            catch (ModuleException e) {
                e.printStackTrace();
            }
        }
    }
}

