/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.geotools.referencing.operation.matrix.Matrix3;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.Formattable;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.Cloneable;

public class AffineTransform2D
extends XAffineTransform
implements MathTransform2D,
LinearTransform,
Formattable,
Cloneable {
    private static final long serialVersionUID = -5299837898367149069L;
    private transient AffineTransform2D inverse;

    public AffineTransform2D(AffineTransform transform) {
        super(transform);
    }

    @Override
    protected final void checkPermission() throws UnsupportedOperationException {
        super.checkPermission();
    }

    @Override
    public final int getSourceDimensions() {
        return 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 2;
    }

    @Override
    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) {
        if (ptDst == null) {
            ptDst = new GeneralDirectPosition(2);
        } else {
            int dimension = ptDst.getDimension();
            if (dimension != 2) {
                throw new MismatchedDimensionException(Errors.format(94, "ptDst", dimension, 2));
            }
        }
        double[] array = ptSrc.getCoordinate();
        this.transform(array, 0, array, 0, 1);
        ptDst.setOrdinate(0, array[0]);
        ptDst.setOrdinate(1, array[1]);
        return ptDst;
    }

    @Override
    public Shape createTransformedShape(Shape shape) {
        return AffineTransform2D.transform((AffineTransform)this, shape, false);
    }

    @Override
    public Matrix getMatrix() {
        return new Matrix3(this);
    }

    @Override
    public Matrix derivative(Point2D point) {
        return new Matrix2(this.getScaleX(), this.getShearX(), this.getShearY(), this.getScaleY());
    }

    @Override
    public Matrix derivative(DirectPosition point) {
        return this.derivative((Point2D)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else {
                try {
                    AffineTransform2D affineTransform2D = this;
                    synchronized (affineTransform2D) {
                        this.inverse = new AffineTransform2D(this.createInverse());
                        this.inverse.inverse = this;
                    }
                }
                catch (java.awt.geom.NoninvertibleTransformException exception) {
                    throw new NoninvertibleTransformException(exception.getLocalizedMessage(), exception);
                }
            }
        }
        return this.inverse;
    }

    @Override
    public AffineTransform clone() {
        return new AffineTransform(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AffineTransform)) {
            return false;
        }
        AffineTransform a = (AffineTransform)obj;
        return Utilities.equals(this.getScaleX(), a.getScaleX()) && Utilities.equals(this.getScaleY(), a.getScaleY()) && Utilities.equals(this.getShearX(), a.getShearX()) && Utilities.equals(this.getShearY(), a.getShearY()) && Utilities.equals(this.getTranslateX(), a.getTranslateX()) && Utilities.equals(this.getTranslateY(), a.getTranslateY());
    }
}

