/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import javax.measure.converter.ConversionException;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.LazySet;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CanonicalSet;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;

public class DefaultMathTransformFactory
extends ReferencingFactory
implements MathTransformFactory {
    private static final Hints HINTS = null;
    private transient MathTransformProvider lastProvider;
    private static final ThreadLocal<OperationMethod> lastMethod = new ThreadLocal();
    private final CanonicalSet<MathTransform> pool;
    private final FactoryRegistry registry;

    public DefaultMathTransformFactory() {
        this(new Class[]{MathTransformProvider.class});
    }

    private DefaultMathTransformFactory(Class<?>[] categories) {
        this.registry = new FactoryRegistry(Arrays.asList(categories));
        this.pool = CanonicalSet.newInstance(MathTransform.class);
    }

    @Override
    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    @Override
    public Set<OperationMethod> getAvailableMethods(Class<? extends Operation> type) {
        return new LazySet<OperationMethod>(this.registry.getServiceProviders(MathTransformProvider.class, (ServiceRegistry.Filter)(type != null ? new MethodFilter(type) : null), HINTS));
    }

    @Override
    public OperationMethod getLastMethodUsed() {
        return lastMethod.get();
    }

    private MathTransformProvider getProvider(String method) throws NoSuchIdentifierException {
        MathTransformProvider provider = this.lastProvider;
        if (provider != null && provider.nameMatches(method)) {
            return provider;
        }
        Iterator<MathTransformProvider> providers = this.registry.getServiceProviders(MathTransformProvider.class, null, HINTS);
        while (providers.hasNext()) {
            provider = providers.next();
            if (!provider.nameMatches(method)) continue;
            this.lastProvider = provider;
            return this.lastProvider;
        }
        throw new NoSuchIdentifierException(Errors.format(141, method), method);
    }

    @Override
    public ParameterValueGroup getDefaultParameters(String method) throws NoSuchIdentifierException {
        return this.getProvider(method).getParameters().createValue();
    }

    @Override
    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, ParameterValueGroup parameters, CoordinateSystem derivedCS) throws NoSuchIdentifierException, FactoryException {
        Ellipsoid ellipsoid = CRSUtilities.getHeadGeoEllipsoid(baseCRS);
        if (ellipsoid != null) {
            Unit<Length> axisUnit = ellipsoid.getAxisUnit();
            Parameters.ensureSet(parameters, "semi_major", ellipsoid.getSemiMajorAxis(), axisUnit, false);
            Parameters.ensureSet(parameters, "semi_minor", ellipsoid.getSemiMinorAxis(), axisUnit, false);
        }
        MathTransform baseToDerived = this.createParameterizedTransform(parameters);
        OperationMethod method = lastMethod.get();
        baseToDerived = this.createBaseToDerived(baseCRS, baseToDerived, derivedCS);
        lastMethod.set(method);
        return baseToDerived;
    }

    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, MathTransform projection, CoordinateSystem derivedCS) throws FactoryException {
        int targetDim;
        int sourceDim;
        Matrix swap3;
        Matrix swap1;
        CoordinateSystem sourceCS = baseCRS.getCoordinateSystem();
        try {
            swap1 = AbstractCS.swapAndScaleAxis(sourceCS, AbstractCS.standard(sourceCS));
            swap3 = AbstractCS.swapAndScaleAxis(AbstractCS.standard(derivedCS), derivedCS);
        }
        catch (IllegalArgumentException cause) {
            throw new FactoryException(cause);
        }
        catch (ConversionException cause) {
            throw new FactoryException(cause);
        }
        MathTransform step1 = this.createAffineTransform(swap1);
        MathTransform step3 = this.createAffineTransform(swap3);
        MathTransform step2 = projection;
        int numTrailingOrdinates = step3.getSourceDimensions() - step2.getTargetDimensions();
        if (numTrailingOrdinates > 0) {
            step2 = this.createPassThroughTransform(0, step2, numTrailingOrdinates);
        }
        if ((sourceDim = step1.getTargetDimensions()) > (targetDim = step2.getSourceDimensions())) {
            XMatrix drop = MatrixFactory.create(targetDim + 1, sourceDim + 1);
            drop.setElement(targetDim, sourceDim, 1.0);
            step1 = this.createConcatenatedTransform(this.createAffineTransform(drop), step1);
        }
        return this.createConcatenatedTransform(this.createConcatenatedTransform(step1, step2), step3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform createParameterizedTransform(ParameterValueGroup parameters) throws NoSuchIdentifierException, FactoryException {
        MathTransform transform;
        OperationMethod method = null;
        try {
            MathTransformProvider provider;
            String classification = parameters.getDescriptor().getName().getCode();
            method = provider = this.getProvider(classification);
            try {
                parameters = provider.ensureValidValues(parameters);
                transform = provider.createMathTransform(parameters);
            }
            catch (IllegalArgumentException exception) {
                throw new FactoryException(exception);
            }
            if (transform instanceof MathTransformProvider.Delegate) {
                MathTransformProvider.Delegate delegate = (MathTransformProvider.Delegate)transform;
                method = delegate.method;
                transform = delegate.transform;
            }
            transform = this.pool.unique(transform);
            lastMethod.set(method);
        }
        catch (Throwable throwable) {
            lastMethod.set(method);
            throw throwable;
        }
        return transform;
    }

    @Override
    public MathTransform createAffineTransform(Matrix matrix) throws FactoryException {
        lastMethod.remove();
        return this.pool.unique(ProjectiveTransform.create(matrix));
    }

    @Override
    public MathTransform createConcatenatedTransform(MathTransform transform1, MathTransform transform2) throws FactoryException {
        MathTransform tr;
        try {
            tr = ConcatenatedTransform.create(transform1, transform2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        tr = this.pool.unique(tr);
        return tr;
    }

    @Override
    public MathTransform createPassThroughTransform(int firstAffectedOrdinate, MathTransform subTransform, int numTrailingOrdinates) throws FactoryException {
        MathTransform tr;
        try {
            tr = PassThroughTransform.create(firstAffectedOrdinate, subTransform, numTrailingOrdinates);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        tr = this.pool.unique(tr);
        return tr;
    }

    private static final class MethodFilter
    implements ServiceRegistry.Filter {
        private final Class<? extends Operation> type;

        public MethodFilter(Class<? extends Operation> type) {
            this.type = type;
        }

        @Override
        public boolean filter(Object element) {
            Class<? extends Operation> t;
            return !(element instanceof MathTransformProvider) || (t = ((MathTransformProvider)element).getOperationType()) == null || this.type.isAssignableFrom(t);
        }
    }
}

