/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

final class OldReferencingObjectCache {
    private final LinkedHashMap pool = new LinkedHashMap(32, 0.75f, true);
    private final int maxStrongReferences;

    public OldReferencingObjectCache(int maxStrongReferences) {
        this.maxStrongReferences = maxStrongReferences;
    }

    public synchronized void clear() {
        if (this.pool != null) {
            this.pool.clear();
        }
    }

    public Object get(Object key) {
        Object object = this.pool.get(key);
        if (object instanceof Reference) {
            object = ((Reference)object).get();
        }
        return object;
    }

    public void put(Object key, Object object) {
        this.pool.put(key, object);
        int toReplace = this.pool.size() - this.maxStrongReferences;
        if (toReplace > 0) {
            Iterator it = this.pool.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object value = entry.getValue();
                if (value instanceof Reference) {
                    if (((Reference)value).get() != null) continue;
                    it.remove();
                    continue;
                }
                entry.setValue(new WeakReference(value));
                if (--toReplace != 0) continue;
                break;
            }
        }
    }

    public Object test(Object key) {
        return null;
    }
}

