/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.AbstractReferenceSystem;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.util.InternationalString;

public abstract class AbstractCRS
extends AbstractReferenceSystem
implements CoordinateReferenceSystem {
    private static final long serialVersionUID = -7433284548909530047L;
    protected final CoordinateSystem coordinateSystem;

    public AbstractCRS(Map<String, ?> properties, CoordinateSystem cs) {
        super(properties);
        AbstractCRS.ensureNonNull("cs", cs);
        this.coordinateSystem = cs;
    }

    static Map<String, ?> name(int key) {
        HashMap<String, CharSequence> properties = new HashMap<String, CharSequence>(4);
        InternationalString name = Vocabulary.formatInternational(key);
        properties.put("name", ((Object)name).toString());
        properties.put("alias", name);
        return properties;
    }

    @Override
    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            AbstractCRS that = (AbstractCRS)object;
            return AbstractCRS.equals(this.coordinateSystem, that.coordinateSystem, compareMetadata);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x3D90441 ^ this.coordinateSystem.hashCode();
    }
}

