/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import org.geotools.geometry.jts.CoordinateSequenceTransformer;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class DefaultCoordinateSequenceTransformer
implements CoordinateSequenceTransformer {
    private final transient double[] buffer = new double[96];
    private final CoordinateSequenceFactory csFactory = DefaultCoordinateSequenceFactory.instance();

    @Override
    public CoordinateSequence transform(CoordinateSequence sequence, MathTransform transform) throws TransformException {
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        int size = sequence.size();
        Coordinate[] tcs = new Coordinate[size];
        int bufferCapacity = this.buffer.length / Math.max(sourceDim, targetDim);
        int remainingBeforeFlush = Math.min(bufferCapacity, size);
        int ib = 0;
        int it = 0;
        int targetCSDim = targetDim + (sequence.getDimension() - sourceDim);
        CoordinateSequence result = this.csFactory.create(sequence.size(), targetCSDim);
        for (int i = 0; i < size; ++i) {
            switch (sourceDim) {
                default: {
                    throw new MismatchedDimensionException();
                }
                case 3: {
                    this.buffer[ib + 2] = sequence.getOrdinate(i, 2);
                }
                case 2: {
                    this.buffer[ib + 1] = sequence.getY(i);
                }
                case 1: {
                    this.buffer[ib] = sequence.getX(i);
                }
                case 0: 
            }
            ib += sourceDim;
            if (--remainingBeforeFlush != 0) continue;
            assert (ib % sourceDim == 0);
            int n = ib / sourceDim;
            transform.transform(this.buffer, 0, this.buffer, 0, n);
            ib = 0;
            for (int j = 0; j < n; ++j) {
                int oi;
                for (oi = 0; oi < targetDim; ++oi) {
                    result.setOrdinate(it, oi, this.buffer[ib++]);
                }
                while (oi < targetCSDim) {
                    result.setOrdinate(it, oi, sequence.getOrdinate(it, oi + (targetDim - sourceDim)));
                    ++oi;
                }
                while (oi < result.getDimension()) {
                    result.setOrdinate(it, oi, Double.NaN);
                    ++oi;
                }
                ++it;
            }
            assert (ib == n * targetDim);
            ib = 0;
            remainingBeforeFlush = Math.min(bufferCapacity, size - (i + 1));
        }
        assert (it == tcs.length) : tcs.length - it;
        return result;
    }
}

