/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.data.DataAccess;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.FilteringSimpleFeatureCollection;
import org.geotools.feature.collection.MaxSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class CollectionFeatureSource
implements SimpleFeatureSource {
    protected SimpleFeatureCollection collection;
    protected List<FeatureListener> listeners = null;
    private QueryCapabilities capabilities;
    private Set<RenderingHints.Key> hints;

    public CollectionFeatureSource(SimpleFeatureCollection collection) {
        this.collection = collection;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return (SimpleFeatureType)this.collection.getSchema();
    }

    @Override
    public synchronized void addFeatureListener(FeatureListener listener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeFeatureListener(FeatureListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    @Override
    public ReferencedEnvelope getBounds() throws IOException {
        return this.collection.getBounds();
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.getFeatures(query).getBounds();
    }

    @Override
    public int getCount(Query query) throws IOException {
        return this.getFeatures(query).size();
    }

    @Override
    public DataAccess<SimpleFeatureType, SimpleFeature> getDataStore() {
        throw new UnsupportedOperationException("CollectionFeatureSource is an inmemory wrapper");
    }

    @Override
    public Name getName() {
        return ((SimpleFeatureType)this.collection.getSchema()).getName();
    }

    @Override
    public synchronized QueryCapabilities getQueryCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new QueryCapabilities(){

                @Override
                public boolean isOffsetSupported() {
                    return true;
                }

                @Override
                public boolean isReliableFIDSupported() {
                    return true;
                }

                @Override
                public boolean supportsSorting(SortBy[] sortAttributes) {
                    return true;
                }
            };
        }
        return this.capabilities;
    }

    @Override
    public synchronized Set<RenderingHints.Key> getSupportedHints() {
        if (this.hints == null) {
            HashSet supports = new HashSet();
            this.hints = Collections.unmodifiableSet(supports);
        }
        return this.hints;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("CollectionFeatureSource:");
        buf.append(this.collection);
        return buf.toString();
    }

    @Override
    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    @Override
    public SimpleFeatureCollection getFeatures(Filter filter) {
        Query query = new Query(this.getSchema().getTypeName(), filter);
        return this.getFeatures(query);
    }

    @Override
    public SimpleFeatureCollection getFeatures(Query query) {
        SimpleFeatureType schema;
        SimpleFeatureType target;
        int offset = (query = DataUtilities.resolvePropertyNames(query, this.getSchema())).getStartIndex() != null ? query.getStartIndex() : 0;
        if (offset > 0 & query.getSortBy() == null) {
            if (!this.getQueryCapabilities().supportsSorting(query.getSortBy())) {
                throw new IllegalStateException("Feature source does not support this sorting so there is no way a stable paging (offset/limit) can be performed");
            }
            Query copy = new Query(query);
            copy.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
            query = copy;
        }
        SimpleFeatureCollection features = this.collection;
        if (query.getFilter() != null && query.getFilter().equals(Filter.EXCLUDE)) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        if (query.getFilter() != null && query.getFilter() != Filter.INCLUDE) {
            features = new FilteringSimpleFeatureCollection(features, query.getFilter());
        }
        if (query.getCoordinateSystemReproject() != null) {
            features = new ReprojectingFeatureCollection(features, query.getCoordinateSystemReproject());
        }
        if (query.getSortBy() != null && query.getSortBy().length != 0) {
            SimpleFeature[] array = features.toArray(new SimpleFeature[features.size()]);
            for (SortBy sortBy : query.getSortBy()) {
                Comparator<SimpleFeature> comparator = DataUtilities.sortComparator(sortBy);
                Arrays.sort(array, comparator);
            }
            ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>(Arrays.asList(array));
            features = new ListFeatureCollection(this.getSchema(), list);
        }
        if (offset > 0 || !query.isMaxFeaturesUnlimited()) {
            long max = Long.MAX_VALUE;
            if (!query.isMaxFeaturesUnlimited()) {
                max = query.getMaxFeatures();
            }
            features = new MaxSimpleFeatureCollection(features, offset, max);
        }
        if (query.getPropertyNames() != Query.ALL_NAMES && !(target = SimpleFeatureTypeBuilder.retype(schema = (SimpleFeatureType)features.getSchema(), query.getPropertyNames())).equals(schema)) {
            features = new ReTypingFeatureCollection(features, target);
        }
        return new SubCollection(query, features);
    }

    protected class SubCollection
    extends DecoratingSimpleFeatureCollection {
        private Query query;

        protected SubCollection(Query query, SimpleFeatureCollection features) {
            super(features);
            this.query = query;
        }

        @Override
        public SimpleFeatureCollection subCollection(Filter filter) {
            Query q = new Query(this.getSchema().getTypeName(), filter);
            Query subQuery = DataUtilities.mixQueries(this.query, q, q.getHandle());
            return CollectionFeatureSource.this.getFeatures(subQuery);
        }
    }
}

