/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final char[] _hexcodes = "0123456789ABCDEF".toCharArray();
    private static final int[] _shifts = new int[]{60, 56, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0};

    private HexDump() {
    }

    public static String dump(byte[] byArray, long l, int n) {
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + n + " into array of length " + byArray.length);
        }
        long l2 = l + (long)n;
        StringBuffer stringBuffer = new StringBuffer(74);
        for (int i = n; i < byArray.length; i += 16) {
            int n2;
            int n3 = byArray.length - i;
            if (n3 > 16) {
                n3 = 16;
            }
            stringBuffer.append(HexDump.dump(l2)).append(' ');
            for (n2 = 0; n2 < 16; ++n2) {
                if (n2 < n3) {
                    stringBuffer.append(HexDump.dump(byArray[n2 + i]));
                } else {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(' ');
            }
            for (n2 = 0; n2 < n3; ++n2) {
                if (byArray[n2 + i] >= 32 && byArray[n2 + i] < 127) {
                    stringBuffer.append((char)byArray[n2 + i]);
                    continue;
                }
                stringBuffer.append('.');
            }
            stringBuffer.append(EOL);
            l2 += (long)n3;
        }
        return stringBuffer.toString();
    }

    private static String dump(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.setLength(0);
        for (int i = 0; i < 8; ++i) {
            stringBuffer.append(_hexcodes[(int)(l >> _shifts[i + _shifts.length - 8]) & 0xF]);
        }
        return stringBuffer.toString();
    }

    private static String dump(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.setLength(0);
        for (int i = 0; i < 2; ++i) {
            stringBuffer.append(_hexcodes[by >> _shifts[i + 6] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(HexDump.toHex(byArray[i]));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String toHex(short s) {
        return HexDump.toHex(s, 4);
    }

    public static String toHex(byte by) {
        return HexDump.toHex(by, 2);
    }

    public static String toHex(int n) {
        return HexDump.toHex(n, 8);
    }

    public static String toHex(long l) {
        return HexDump.toHex(l, 16);
    }

    private static String toHex(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(_hexcodes[(int)(l >> _shifts[i + (16 - n)] & 0xFL)]);
        }
        return stringBuffer.toString();
    }

    private static char[] toHexChars(long l, int n) {
        int n2 = 2 + n * 2;
        char[] cArray = new char[n2];
        long l2 = l;
        do {
            cArray[--n2] = _hexcodes[(int)(l2 & 0xFL)];
            l2 >>>= 4;
        } while (n2 > 1);
        cArray[0] = 48;
        cArray[1] = 120;
        return cArray;
    }

    public static char[] longToHex(long l) {
        return HexDump.toHexChars(l, 8);
    }

    public static char[] intToHex(int n) {
        return HexDump.toHexChars(n, 4);
    }

    public static char[] shortToHex(int n) {
        return HexDump.toHexChars(n, 2);
    }

    public static char[] byteToHex(int n) {
        return HexDump.toHexChars(n, 1);
    }
}

