/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.util.CellReference;

public class AreaReference {
    private static final char CELL_DELIMITER = ':';
    private final CellReference _firstCell;
    private final CellReference _lastCell;
    private final boolean _isSingleCell;

    public AreaReference(CellReference cellReference, CellReference cellReference2) {
        boolean bl;
        boolean bl2 = cellReference.getRow() > cellReference2.getRow();
        boolean bl3 = bl = cellReference.getCol() > cellReference2.getCol();
        if (bl2 || bl) {
            boolean bl4;
            short s;
            boolean bl5;
            short s2;
            boolean bl6;
            int n;
            boolean bl7;
            int n2;
            if (bl2) {
                n2 = cellReference2.getRow();
                bl7 = cellReference2.isRowAbsolute();
                n = cellReference.getRow();
                bl6 = cellReference.isRowAbsolute();
            } else {
                n2 = cellReference.getRow();
                bl7 = cellReference.isRowAbsolute();
                n = cellReference2.getRow();
                bl6 = cellReference2.isRowAbsolute();
            }
            if (bl) {
                s2 = cellReference2.getCol();
                bl5 = cellReference2.isColAbsolute();
                s = cellReference.getCol();
                bl4 = cellReference.isColAbsolute();
            } else {
                s2 = cellReference.getCol();
                bl5 = cellReference.isColAbsolute();
                s = cellReference2.getCol();
                bl4 = cellReference2.isColAbsolute();
            }
            this._firstCell = new CellReference(n2, s2, bl7, bl5);
            this._lastCell = new CellReference(n, s, bl6, bl4);
        } else {
            this._firstCell = cellReference;
            this._lastCell = cellReference2;
        }
        this._isSingleCell = false;
    }

    public static boolean isWholeColumnReference(CellReference cellReference, CellReference cellReference2) {
        return cellReference.getRow() == 0 && cellReference.isRowAbsolute() && cellReference2.getRow() == SpreadsheetVersion.EXCEL97.getLastRowIndex() && cellReference2.isRowAbsolute();
    }

    public boolean isWholeColumnReference() {
        return AreaReference.isWholeColumnReference(this._firstCell, this._lastCell);
    }

    public String formatAsString() {
        if (this.isWholeColumnReference()) {
            return CellReference.convertNumToColString(this._firstCell.getCol()) + ":" + CellReference.convertNumToColString(this._lastCell.getCol());
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this._firstCell.formatAsString());
        if (!this._isSingleCell) {
            stringBuffer.append(':');
            if (this._lastCell.getSheetName() == null) {
                stringBuffer.append(this._lastCell.formatAsString());
            } else {
                this._lastCell.appendCellReference(stringBuffer);
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.formatAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

