/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;

public final class HSSFCellStyle
implements CellStyle {
    private ExtendedFormatRecord _format = null;
    private short _index = 0;
    private InternalWorkbook _workbook = null;

    protected HSSFCellStyle(short s, ExtendedFormatRecord extendedFormatRecord, HSSFWorkbook hSSFWorkbook) {
        this(s, extendedFormatRecord, hSSFWorkbook.getWorkbook());
    }

    protected HSSFCellStyle(short s, ExtendedFormatRecord extendedFormatRecord, InternalWorkbook internalWorkbook) {
        this._workbook = internalWorkbook;
        this._index = s;
        this._format = extendedFormatRecord;
    }

    @Override
    public short getIndex() {
        return this._index;
    }

    @Override
    public short getDataFormat() {
        return this._format.getFormatIndex();
    }

    @Override
    public String getDataFormatString() {
        return this.getDataFormatString(this._workbook);
    }

    public String getDataFormatString(InternalWorkbook internalWorkbook) {
        HSSFDataFormat hSSFDataFormat = new HSSFDataFormat(internalWorkbook);
        return hSSFDataFormat.getFormat(this.getDataFormat());
    }

    public void verifyBelongsToWorkbook(HSSFWorkbook hSSFWorkbook) {
        if (hSSFWorkbook.getWorkbook() != this._workbook) {
            throw new IllegalArgumentException("This Style does not belong to the supplied Workbook. Are you trying to assign a style from one workbook to the cell of a differnt workbook?");
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._format == null ? 0 : this._format.hashCode());
        n = 31 * n + this._index;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof HSSFCellStyle) {
            HSSFCellStyle hSSFCellStyle = (HSSFCellStyle)object;
            if (this._format == null ? hSSFCellStyle._format != null : !this._format.equals(hSSFCellStyle._format)) {
                return false;
            }
            return this._index == hSSFCellStyle._index;
        }
        return false;
    }
}

