/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.usermodel.HSSFErrorConstants;

public final class ErrorEval {
    private static final int CIRCULAR_REF_ERROR_CODE = -60;
    private static final int FUNCTION_NOT_IMPLEMENTED_CODE = -30;
    private int _errorCode;

    public static String getText(int n) {
        if (HSSFErrorConstants.isValidCode(n)) {
            return HSSFErrorConstants.getText(n);
        }
        switch (n) {
            case -60: {
                return "~CIRCULAR~REF~";
            }
            case -30: {
                return "~FUNCTION~NOT~IMPLEMENTED~";
            }
        }
        return "~non~std~err(" + n + ")~";
    }

    private ErrorEval(int n) {
        this._errorCode = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(ErrorEval.getText(this._errorCode));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

