/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellRecord;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class LabelSSTRecord
extends CellRecord {
    public static final short sid = 253;
    private int field_4_sst_index;

    public LabelSSTRecord() {
    }

    public LabelSSTRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        this.field_4_sst_index = recordInputStream.readInt();
    }

    public void setSSTIndex(int n) {
        this.field_4_sst_index = n;
    }

    public int getSSTIndex() {
        return this.field_4_sst_index;
    }

    @Override
    protected String getRecordName() {
        return "LABELSST";
    }

    @Override
    protected void appendValueText(StringBuilder stringBuilder) {
        stringBuilder.append("  .sstIndex = ");
        stringBuilder.append(HexDump.shortToHex(this.getXFIndex()));
    }

    @Override
    protected void serializeValue(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.getSSTIndex());
    }

    @Override
    protected int getValueDataSize() {
        return 4;
    }

    @Override
    public short getSid() {
        return 253;
    }

    @Override
    public Object clone() {
        LabelSSTRecord labelSSTRecord = new LabelSSTRecord();
        this.copyBaseFields(labelSSTRecord);
        labelSSTRecord.field_4_sst_index = this.field_4_sst_index;
        return labelSSTRecord;
    }
}

