/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class BoundSheetRecord
extends StandardRecord {
    public static final short sid = 133;
    private int field_1_position_of_BOF;
    private int field_2_option_flags;
    private int field_4_isMultibyteUnicode;
    private String field_5_sheetname;

    public BoundSheetRecord(RecordInputStream recordInputStream) {
        this.field_1_position_of_BOF = recordInputStream.readInt();
        this.field_2_option_flags = recordInputStream.readUShort();
        int n = recordInputStream.readUByte();
        this.field_4_isMultibyteUnicode = recordInputStream.readByte();
        this.field_5_sheetname = this.isMultibyte() ? recordInputStream.readUnicodeLEString(n) : recordInputStream.readCompressedUnicode(n);
    }

    public int getPositionOfBof() {
        return this.field_1_position_of_BOF;
    }

    private boolean isMultibyte() {
        return (this.field_4_isMultibyteUnicode & 1) != 0;
    }

    public String getSheetname() {
        return this.field_5_sheetname;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BOUNDSHEET]\n");
        stringBuffer.append("    .bof        = ").append(HexDump.intToHex(this.getPositionOfBof())).append("\n");
        stringBuffer.append("    .options    = ").append(HexDump.shortToHex(this.field_2_option_flags)).append("\n");
        stringBuffer.append("    .unicodeflag= ").append(HexDump.byteToHex(this.field_4_isMultibyteUnicode)).append("\n");
        stringBuffer.append("    .sheetname  = ").append(this.field_5_sheetname).append("\n");
        stringBuffer.append("[/BOUNDSHEET]\n");
        return stringBuffer.toString();
    }

    @Override
    protected int getDataSize() {
        return 8 + this.field_5_sheetname.length() * (this.isMultibyte() ? 2 : 1);
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.getPositionOfBof());
        littleEndianOutput.writeShort(this.field_2_option_flags);
        String string = this.field_5_sheetname;
        littleEndianOutput.writeByte(string.length());
        littleEndianOutput.writeByte(this.field_4_isMultibyteUnicode);
        if (this.isMultibyte()) {
            StringUtil.putUnicodeLE(string, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(string, littleEndianOutput);
        }
    }

    @Override
    public short getSid() {
        return 133;
    }
}

