/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.IllegalPropertySetDataException;
import org.apache.poi.hpsf.MutableSection;
import org.apache.poi.hpsf.NoFormatIDException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.Section;
import org.apache.poi.hpsf.TypeWriter;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.util.LittleEndian;

public class MutablePropertySet
extends PropertySet {
    private final int OFFSET_HEADER = BYTE_ORDER_ASSERTION.length + FORMAT_ASSERTION.length + 4 + 16 + 4;

    public MutablePropertySet() {
        this.byteOrder = LittleEndian.getUShort(BYTE_ORDER_ASSERTION);
        this.format = LittleEndian.getUShort(FORMAT_ASSERTION);
        this.osVersion = 133636;
        this.classID = new ClassID();
        this.sections = new LinkedList();
        this.sections.add(new MutableSection());
    }

    public MutablePropertySet(PropertySet propertySet) {
        this.byteOrder = propertySet.getByteOrder();
        this.format = propertySet.getFormat();
        this.osVersion = propertySet.getOSVersion();
        this.setClassID(propertySet.getClassID());
        this.clearSections();
        if (this.sections == null) {
            this.sections = new LinkedList();
        }
        Iterator<Section> iterator = propertySet.getSections().iterator();
        while (iterator.hasNext()) {
            this.addSection(new MutableSection(iterator.next()));
        }
    }

    public void setByteOrder(int n) {
        this.byteOrder = n;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public void setOSVersion(int n) {
        this.osVersion = n;
    }

    public void setClassID(ClassID classID) {
        this.classID = classID;
    }

    public void clearSections() {
        this.sections = null;
    }

    public void addSection(Section section) {
        if (this.sections == null) {
            this.sections = new LinkedList();
        }
        this.sections.add(section);
    }

    public void write(OutputStream outputStream) throws WritingNotSupportedException, IOException {
        MutableSection mutableSection;
        int n = this.sections.size();
        TypeWriter.writeToStream(outputStream, (short)this.getByteOrder());
        TypeWriter.writeToStream(outputStream, (short)this.getFormat());
        TypeWriter.writeToStream(outputStream, this.getOSVersion());
        TypeWriter.writeToStream(outputStream, this.getClassID());
        TypeWriter.writeToStream(outputStream, n);
        int n2 = this.OFFSET_HEADER;
        int n3 = n2 += n * 20;
        ListIterator listIterator = this.sections.listIterator();
        while (listIterator.hasNext()) {
            mutableSection = (MutableSection)listIterator.next();
            ClassID classID = mutableSection.getFormatID();
            if (classID == null) {
                throw new NoFormatIDException();
            }
            TypeWriter.writeToStream(outputStream, mutableSection.getFormatID());
            TypeWriter.writeUIntToStream(outputStream, n2);
            try {
                n2 += mutableSection.getSize();
            }
            catch (HPSFRuntimeException hPSFRuntimeException) {
                Throwable throwable = hPSFRuntimeException.getReason();
                if (throwable instanceof UnsupportedEncodingException) {
                    throw new IllegalPropertySetDataException(throwable);
                }
                throw hPSFRuntimeException;
            }
        }
        n2 = n3;
        listIterator = this.sections.listIterator();
        while (listIterator.hasNext()) {
            mutableSection = (MutableSection)listIterator.next();
            n2 += mutableSection.write(outputStream);
        }
    }

    public InputStream toInputStream() throws IOException, WritingNotSupportedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new ByteArrayInputStream(byArray);
    }

    public void write(DirectoryEntry directoryEntry, String string) throws WritingNotSupportedException, IOException {
        try {
            Entry entry = directoryEntry.getEntry(string);
            entry.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        directoryEntry.createDocument(string, this.toInputStream());
    }
}

