/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.relate;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeMap;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.operation.relate.EdgeEndBuilder;
import com.vividsolutions.jts.operation.relate.RelateNode;
import com.vividsolutions.jts.operation.relate.RelateNodeFactory;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RelateComputer {
    private LineIntersector li = new RobustLineIntersector();
    private PointLocator ptLocator = new PointLocator();
    private GeometryGraph[] arg;
    private NodeMap nodes = new NodeMap(new RelateNodeFactory());
    private ArrayList isolatedEdges = new ArrayList();

    public RelateComputer(GeometryGraph[] geometryGraphArray) {
        this.arg = geometryGraphArray;
    }

    public IntersectionMatrix computeIM() {
        IntersectionMatrix intersectionMatrix = new IntersectionMatrix();
        intersectionMatrix.set(2, 2, 2);
        if (!this.arg[0].getGeometry().getEnvelopeInternal().intersects(this.arg[1].getGeometry().getEnvelopeInternal())) {
            this.computeDisjointIM(intersectionMatrix);
            return intersectionMatrix;
        }
        this.arg[0].computeSelfNodes(this.li, false);
        this.arg[1].computeSelfNodes(this.li, false);
        SegmentIntersector segmentIntersector = this.arg[0].computeEdgeIntersections(this.arg[1], this.li, false);
        this.computeIntersectionNodes(0);
        this.computeIntersectionNodes(1);
        this.copyNodesAndLabels(0);
        this.copyNodesAndLabels(1);
        this.labelIsolatedNodes();
        this.computeProperIntersectionIM(segmentIntersector, intersectionMatrix);
        EdgeEndBuilder edgeEndBuilder = new EdgeEndBuilder();
        List list = edgeEndBuilder.computeEdgeEnds(this.arg[0].getEdgeIterator());
        this.insertEdgeEnds(list);
        List list2 = edgeEndBuilder.computeEdgeEnds(this.arg[1].getEdgeIterator());
        this.insertEdgeEnds(list2);
        this.labelNodeEdges();
        this.labelIsolatedEdges(0, 1);
        this.labelIsolatedEdges(1, 0);
        this.updateIM(intersectionMatrix);
        return intersectionMatrix;
    }

    private void insertEdgeEnds(List list) {
        for (EdgeEnd edgeEnd : list) {
            this.nodes.add(edgeEnd);
        }
    }

    private void computeProperIntersectionIM(SegmentIntersector segmentIntersector, IntersectionMatrix intersectionMatrix) {
        int n = this.arg[0].getGeometry().getDimension();
        int n2 = this.arg[1].getGeometry().getDimension();
        boolean bl = segmentIntersector.hasProperIntersection();
        boolean bl2 = segmentIntersector.hasProperInteriorIntersection();
        if (n == 2 && n2 == 2) {
            if (bl) {
                intersectionMatrix.setAtLeast("212101212");
            }
        } else if (n == 2 && n2 == 1) {
            if (bl) {
                intersectionMatrix.setAtLeast("FFF0FFFF2");
            }
            if (bl2) {
                intersectionMatrix.setAtLeast("1FFFFF1FF");
            }
        } else if (n == 1 && n2 == 2) {
            if (bl) {
                intersectionMatrix.setAtLeast("F0FFFFFF2");
            }
            if (bl2) {
                intersectionMatrix.setAtLeast("1F1FFFFFF");
            }
        } else if (n == 1 && n2 == 1 && bl2) {
            intersectionMatrix.setAtLeast("0FFFFFFFF");
        }
    }

    private void copyNodesAndLabels(int n) {
        Iterator iterator = this.arg[n].getNodeIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Node node2 = this.nodes.addNode(node.getCoordinate());
            node2.setLabel(n, node.getLabel().getLocation(n));
        }
    }

    private void computeIntersectionNodes(int n) {
        Iterator iterator = this.arg[n].getEdgeIterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            int n2 = edge.getLabel().getLocation(n);
            Iterator iterator2 = edge.getEdgeIntersectionList().iterator();
            while (iterator2.hasNext()) {
                EdgeIntersection edgeIntersection = (EdgeIntersection)iterator2.next();
                RelateNode relateNode = (RelateNode)this.nodes.addNode(edgeIntersection.coord);
                if (n2 == 1) {
                    relateNode.setLabelBoundary(n);
                    continue;
                }
                if (!relateNode.getLabel().isNull(n)) continue;
                relateNode.setLabel(n, 0);
            }
        }
    }

    private void computeDisjointIM(IntersectionMatrix intersectionMatrix) {
        Geometry geometry;
        Geometry geometry2 = this.arg[0].getGeometry();
        if (!geometry2.isEmpty()) {
            intersectionMatrix.set(0, 2, geometry2.getDimension());
            intersectionMatrix.set(1, 2, geometry2.getBoundaryDimension());
        }
        if (!(geometry = this.arg[1].getGeometry()).isEmpty()) {
            intersectionMatrix.set(2, 0, geometry.getDimension());
            intersectionMatrix.set(2, 1, geometry.getBoundaryDimension());
        }
    }

    private void labelNodeEdges() {
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            RelateNode relateNode = (RelateNode)iterator.next();
            relateNode.getEdges().computeLabelling(this.arg);
        }
    }

    private void updateIM(IntersectionMatrix intersectionMatrix) {
        for (GraphComponent graphComponent : this.isolatedEdges) {
            graphComponent.updateIM(intersectionMatrix);
        }
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            GraphComponent graphComponent;
            graphComponent = (RelateNode)iterator.next();
            graphComponent.updateIM(intersectionMatrix);
            ((RelateNode)graphComponent).updateIMFromEdges(intersectionMatrix);
        }
    }

    private void labelIsolatedEdges(int n, int n2) {
        Iterator iterator = this.arg[n].getEdgeIterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.isIsolated()) continue;
            this.labelIsolatedEdge(edge, n2, this.arg[n2].getGeometry());
            this.isolatedEdges.add(edge);
        }
    }

    private void labelIsolatedEdge(Edge edge, int n, Geometry geometry) {
        if (geometry.getDimension() > 0) {
            int n2 = this.ptLocator.locate(edge.getCoordinate(), geometry);
            edge.getLabel().setAllLocations(n, n2);
        } else {
            edge.getLabel().setAllLocations(n, 2);
        }
    }

    private void labelIsolatedNodes() {
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Label label = node.getLabel();
            Assert.isTrue(label.getGeometryCount() > 0, "node with empty label found");
            if (!node.isIsolated()) continue;
            if (label.isNull(0)) {
                this.labelIsolatedNode(node, 0);
                continue;
            }
            this.labelIsolatedNode(node, 1);
        }
    }

    private void labelIsolatedNode(Node node, int n) {
        int n2 = this.ptLocator.locate(node.getCoordinate(), this.arg[n].getGeometry());
        node.getLabel().setAllLocations(n, n2);
    }
}

