/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class RectangleContains {
    private Envelope rectEnv;

    public static boolean contains(Polygon polygon, Geometry geometry) {
        RectangleContains rectangleContains = new RectangleContains(polygon);
        return rectangleContains.contains(geometry);
    }

    public RectangleContains(Polygon polygon) {
        this.rectEnv = polygon.getEnvelopeInternal();
    }

    public boolean contains(Geometry geometry) {
        if (!this.rectEnv.contains(geometry.getEnvelopeInternal())) {
            return false;
        }
        return !this.isContainedInBoundary(geometry);
    }

    private boolean isContainedInBoundary(Geometry geometry) {
        if (geometry instanceof Polygon) {
            return false;
        }
        if (geometry instanceof Point) {
            return this.isPointContainedInBoundary((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return this.isLineStringContainedInBoundary((LineString)geometry);
        }
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry geometry2 = geometry.getGeometryN(i);
            if (this.isContainedInBoundary(geometry2)) continue;
            return false;
        }
        return true;
    }

    private boolean isPointContainedInBoundary(Point point) {
        return this.isPointContainedInBoundary(point.getCoordinate());
    }

    private boolean isPointContainedInBoundary(Coordinate coordinate) {
        return coordinate.x == this.rectEnv.getMinX() || coordinate.x == this.rectEnv.getMaxX() || coordinate.y == this.rectEnv.getMinY() || coordinate.y == this.rectEnv.getMaxY();
    }

    private boolean isLineStringContainedInBoundary(LineString lineString) {
        CoordinateSequence coordinateSequence = lineString.getCoordinateSequence();
        Coordinate coordinate = new Coordinate();
        Coordinate coordinate2 = new Coordinate();
        for (int i = 0; i < coordinateSequence.size() - 1; ++i) {
            coordinateSequence.getCoordinate(i, coordinate);
            coordinateSequence.getCoordinate(i + 1, coordinate2);
            if (this.isLineSegmentContainedInBoundary(coordinate, coordinate2)) continue;
            return false;
        }
        return true;
    }

    private boolean isLineSegmentContainedInBoundary(Coordinate coordinate, Coordinate coordinate2) {
        if (coordinate.equals(coordinate2)) {
            return this.isPointContainedInBoundary(coordinate);
        }
        return coordinate.x == coordinate2.x ? coordinate.x == this.rectEnv.getMinX() || coordinate.x == this.rectEnv.getMaxX() : coordinate.y == coordinate2.y && (coordinate.y == this.rectEnv.getMinY() || coordinate.y == this.rectEnv.getMaxY());
    }
}

