/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class LineBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private List lineEdgesList = new ArrayList();
    private List resultLineList = new ArrayList();

    public LineBuilder(OverlayOp overlayOp, GeometryFactory geometryFactory) {
        this.op = overlayOp;
        this.geometryFactory = geometryFactory;
    }

    public List build(int n) {
        this.findCoveredLineEdges();
        this.collectLines(n);
        this.buildLines();
        return this.resultLineList;
    }

    private void findCoveredLineEdges() {
        for (Object object : this.op.getGraph().getNodes()) {
            ((DirectedEdgeStar)((Node)object).getEdges()).findCoveredLineEdges();
        }
        for (Object object : this.op.getGraph().getEdgeEnds()) {
            Edge edge = ((DirectedEdge)object).getEdge();
            if (!((DirectedEdge)object).isLineEdge() || edge.isCoveredSet()) continue;
            boolean bl = this.op.isCoveredByA(((EdgeEnd)object).getCoordinate());
            edge.setCovered(bl);
        }
    }

    private void collectLines(int n) {
        for (DirectedEdge directedEdge : this.op.getGraph().getEdgeEnds()) {
            this.collectLineEdge(directedEdge, n, this.lineEdgesList);
            this.collectBoundaryTouchEdge(directedEdge, n, this.lineEdgesList);
        }
    }

    private void collectLineEdge(DirectedEdge directedEdge, int n, List list) {
        Label label = directedEdge.getLabel();
        Edge edge = directedEdge.getEdge();
        if (directedEdge.isLineEdge() && !directedEdge.isVisited() && OverlayOp.isResultOfOp(label, n) && !edge.isCovered()) {
            list.add(edge);
            directedEdge.setVisitedEdge(true);
        }
    }

    private void collectBoundaryTouchEdge(DirectedEdge directedEdge, int n, List list) {
        Label label = directedEdge.getLabel();
        if (directedEdge.isLineEdge()) {
            return;
        }
        if (directedEdge.isVisited()) {
            return;
        }
        if (directedEdge.isInteriorAreaEdge()) {
            return;
        }
        if (directedEdge.getEdge().isInResult()) {
            return;
        }
        Assert.isTrue(!directedEdge.isInResult() && !directedEdge.getSym().isInResult() || !directedEdge.getEdge().isInResult());
        if (OverlayOp.isResultOfOp(label, n) && n == 1) {
            list.add(directedEdge.getEdge());
            directedEdge.setVisitedEdge(true);
        }
    }

    private void buildLines() {
        for (Edge edge : this.lineEdgesList) {
            LineString lineString = this.geometryFactory.createLineString(edge.getCoordinates());
            this.resultLineList.add(lineString);
            edge.setInResult(true);
        }
    }
}

