/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.Counter;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class BoundaryOp {
    private Geometry geom;
    private GeometryFactory geomFact;
    private BoundaryNodeRule bnRule;
    private Map endpointMap;

    public BoundaryOp(Geometry geometry) {
        this(geometry, BoundaryNodeRule.MOD2_BOUNDARY_RULE);
    }

    public BoundaryOp(Geometry geometry, BoundaryNodeRule boundaryNodeRule) {
        this.geom = geometry;
        this.geomFact = geometry.getFactory();
        this.bnRule = boundaryNodeRule;
    }

    public Geometry getBoundary() {
        if (this.geom instanceof LineString) {
            return this.boundaryLineString((LineString)this.geom);
        }
        if (this.geom instanceof MultiLineString) {
            return this.boundaryMultiLineString((MultiLineString)this.geom);
        }
        return this.geom.getBoundary();
    }

    private MultiPoint getEmptyMultiPoint() {
        return this.geomFact.createMultiPoint((CoordinateSequence)null);
    }

    private Geometry boundaryMultiLineString(MultiLineString multiLineString) {
        if (this.geom.isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        Coordinate[] coordinateArray = this.computeBoundaryCoordinates(multiLineString);
        if (coordinateArray.length == 1) {
            return this.geomFact.createPoint(coordinateArray[0]);
        }
        return this.geomFact.createMultiPoint(coordinateArray);
    }

    private Coordinate[] computeBoundaryCoordinates(MultiLineString multiLineString) {
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        this.endpointMap = new TreeMap();
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            LineString object = (LineString)multiLineString.getGeometryN(i);
            if (object.getNumPoints() == 0) continue;
            this.addEndpoint(object.getCoordinateN(0));
            this.addEndpoint(object.getCoordinateN(object.getNumPoints() - 1));
        }
        for (Map.Entry entry : this.endpointMap.entrySet()) {
            Counter counter = (Counter)entry.getValue();
            int n = counter.count;
            if (!this.bnRule.isInBoundary(n)) continue;
            arrayList.add((Coordinate)entry.getKey());
        }
        return CoordinateArrays.toCoordinateArray(arrayList);
    }

    private void addEndpoint(Coordinate coordinate) {
        Counter counter = (Counter)this.endpointMap.get(coordinate);
        if (counter == null) {
            counter = new Counter();
            this.endpointMap.put(coordinate, counter);
        }
        ++counter.count;
    }

    private Geometry boundaryLineString(LineString lineString) {
        if (this.geom.isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        if (lineString.isClosed()) {
            boolean bl = this.bnRule.isInBoundary(2);
            if (bl) {
                return lineString.getStartPoint();
            }
            return this.geomFact.createMultiPoint((Coordinate[])null);
        }
        return this.geomFact.createMultiPoint(new Point[]{lineString.getStartPoint(), lineString.getEndPoint()});
    }
}

