/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.noding.NodableSegmentString;
import com.vividsolutions.jts.noding.Octant;
import com.vividsolutions.jts.noding.SegmentNodeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodedSegmentString
implements NodableSegmentString {
    private SegmentNodeList nodeList = new SegmentNodeList(this);
    private Coordinate[] pts;
    private Object data;

    public static List getNodedSubstrings(Collection collection) {
        ArrayList arrayList = new ArrayList();
        NodedSegmentString.getNodedSubstrings(collection, arrayList);
        return arrayList;
    }

    public static void getNodedSubstrings(Collection collection, Collection collection2) {
        for (NodedSegmentString nodedSegmentString : collection) {
            nodedSegmentString.getNodeList().addSplitEdges(collection2);
        }
    }

    public NodedSegmentString(Coordinate[] coordinateArray, Object object) {
        this.pts = coordinateArray;
        this.data = object;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public SegmentNodeList getNodeList() {
        return this.nodeList;
    }

    @Override
    public int size() {
        return this.pts.length;
    }

    @Override
    public Coordinate getCoordinate(int n) {
        return this.pts[n];
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public int getSegmentOctant(int n) {
        if (n == this.pts.length - 1) {
            return -1;
        }
        return this.safeOctant(this.getCoordinate(n), this.getCoordinate(n + 1));
    }

    private int safeOctant(Coordinate coordinate, Coordinate coordinate2) {
        if (coordinate.equals2D(coordinate2)) {
            return 0;
        }
        return Octant.octant(coordinate, coordinate2);
    }

    public String toString() {
        return WKTWriter.toLineString(new CoordinateArraySequence(this.pts));
    }
}

