/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.prep.PreparedPolygon;
import com.vividsolutions.jts.geom.prep.PreparedPolygonPredicate;
import com.vividsolutions.jts.noding.SegmentIntersectionDetector;
import com.vividsolutions.jts.noding.SegmentStringUtil;
import java.util.List;

abstract class AbstractPreparedPolygonContains
extends PreparedPolygonPredicate {
    protected boolean requireSomePointInInterior = true;
    private boolean hasSegmentIntersection = false;
    private boolean hasProperIntersection = false;
    private boolean hasNonProperIntersection = false;

    public AbstractPreparedPolygonContains(PreparedPolygon preparedPolygon) {
        super(preparedPolygon);
    }

    protected boolean eval(Geometry geometry) {
        boolean bl;
        boolean bl2 = this.isAllTestComponentsInTarget(geometry);
        if (!bl2) {
            return false;
        }
        if (this.requireSomePointInInterior && geometry.getDimension() == 0) {
            boolean bl3 = this.isAnyTestComponentInTargetInterior(geometry);
            return bl3;
        }
        boolean bl4 = this.isProperIntersectionImpliesNotContainedSituation(geometry);
        this.findAndClassifyIntersections(geometry);
        if (bl4 && this.hasProperIntersection) {
            return false;
        }
        if (this.hasSegmentIntersection && !this.hasNonProperIntersection) {
            return false;
        }
        if (this.hasSegmentIntersection) {
            return this.fullTopologicalPredicate(geometry);
        }
        return !(geometry instanceof Polygonal) || !(bl = this.isAnyTargetComponentInAreaTest(geometry, this.prepPoly.getRepresentativePoints()));
    }

    private boolean isProperIntersectionImpliesNotContainedSituation(Geometry geometry) {
        if (geometry instanceof Polygonal) {
            return true;
        }
        return this.isSingleShell(this.prepPoly.getGeometry());
    }

    private boolean isSingleShell(Geometry geometry) {
        if (geometry.getNumGeometries() != 1) {
            return false;
        }
        Polygon polygon = (Polygon)geometry.getGeometryN(0);
        int n = polygon.getNumInteriorRing();
        return n == 0;
    }

    private void findAndClassifyIntersections(Geometry geometry) {
        List list = SegmentStringUtil.extractSegmentStrings(geometry);
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        SegmentIntersectionDetector segmentIntersectionDetector = new SegmentIntersectionDetector(robustLineIntersector);
        segmentIntersectionDetector.setFindAllIntersectionTypes(true);
        this.prepPoly.getIntersectionFinder().intersects(list, segmentIntersectionDetector);
        this.hasSegmentIntersection = segmentIntersectionDetector.hasIntersection();
        this.hasProperIntersection = segmentIntersectionDetector.hasProperIntersection();
        this.hasNonProperIntersection = segmentIntersectionDetector.hasNonProperIntersection();
    }

    protected abstract boolean fullTopologicalPredicate(Geometry var1);
}

