/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jts.util.UniqueCoordinateArrayFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;
import java.util.TreeSet;

public class ConvexHull {
    private GeometryFactory geomFactory;
    private Coordinate[] inputPts;

    public ConvexHull(Geometry geometry) {
        this(ConvexHull.extractCoordinates(geometry), geometry.getFactory());
    }

    public ConvexHull(Coordinate[] coordinateArray, GeometryFactory geometryFactory) {
        this.inputPts = coordinateArray;
        this.geomFactory = geometryFactory;
    }

    private static Coordinate[] extractCoordinates(Geometry geometry) {
        UniqueCoordinateArrayFilter uniqueCoordinateArrayFilter = new UniqueCoordinateArrayFilter();
        geometry.apply(uniqueCoordinateArrayFilter);
        return uniqueCoordinateArrayFilter.getCoordinates();
    }

    public Geometry getConvexHull() {
        if (this.inputPts.length == 0) {
            return this.geomFactory.createGeometryCollection(null);
        }
        if (this.inputPts.length == 1) {
            return this.geomFactory.createPoint(this.inputPts[0]);
        }
        if (this.inputPts.length == 2) {
            return this.geomFactory.createLineString(this.inputPts);
        }
        Coordinate[] coordinateArray = this.inputPts;
        if (this.inputPts.length > 50) {
            coordinateArray = this.reduce(this.inputPts);
        }
        Coordinate[] coordinateArray2 = this.preSort(coordinateArray);
        Stack stack = this.grahamScan(coordinateArray2);
        Coordinate[] coordinateArray3 = this.toCoordinateArray(stack);
        return this.lineOrPolygon(coordinateArray3);
    }

    protected Coordinate[] toCoordinateArray(Stack stack) {
        Coordinate[] coordinateArray = new Coordinate[stack.size()];
        for (int i = 0; i < stack.size(); ++i) {
            Coordinate coordinate;
            coordinateArray[i] = coordinate = (Coordinate)stack.get(i);
        }
        return coordinateArray;
    }

    private Coordinate[] reduce(Coordinate[] coordinateArray) {
        int n;
        Coordinate[] coordinateArray2 = this.computeOctRing(coordinateArray);
        if (coordinateArray2 == null) {
            return coordinateArray;
        }
        TreeSet<Coordinate> treeSet = new TreeSet<Coordinate>();
        for (n = 0; n < coordinateArray2.length; ++n) {
            treeSet.add(coordinateArray2[n]);
        }
        for (n = 0; n < coordinateArray.length; ++n) {
            if (CGAlgorithms.isPointInRing(coordinateArray[n], coordinateArray2)) continue;
            treeSet.add(coordinateArray[n]);
        }
        Coordinate[] coordinateArray3 = CoordinateArrays.toCoordinateArray(treeSet);
        if (coordinateArray3.length < 3) {
            return this.padArray3(coordinateArray3);
        }
        return coordinateArray3;
    }

    private Coordinate[] padArray3(Coordinate[] coordinateArray) {
        Coordinate[] coordinateArray2 = new Coordinate[3];
        for (int i = 0; i < coordinateArray2.length; ++i) {
            coordinateArray2[i] = i < coordinateArray.length ? coordinateArray[i] : coordinateArray[0];
        }
        return coordinateArray2;
    }

    private Coordinate[] preSort(Coordinate[] coordinateArray) {
        for (int i = 1; i < coordinateArray.length; ++i) {
            if (!(coordinateArray[i].y < coordinateArray[0].y) && (coordinateArray[i].y != coordinateArray[0].y || !(coordinateArray[i].x < coordinateArray[0].x))) continue;
            Coordinate coordinate = coordinateArray[0];
            coordinateArray[0] = coordinateArray[i];
            coordinateArray[i] = coordinate;
        }
        Arrays.sort(coordinateArray, 1, coordinateArray.length, new RadialComparator(coordinateArray[0]));
        return coordinateArray;
    }

    private Stack grahamScan(Coordinate[] coordinateArray) {
        Stack<Coordinate> stack = new Stack<Coordinate>();
        Coordinate coordinate = stack.push(coordinateArray[0]);
        coordinate = stack.push(coordinateArray[1]);
        coordinate = stack.push(coordinateArray[2]);
        for (int i = 3; i < coordinateArray.length; ++i) {
            coordinate = (Coordinate)stack.pop();
            while (CGAlgorithms.computeOrientation((Coordinate)stack.peek(), coordinate, coordinateArray[i]) > 0) {
                coordinate = (Coordinate)stack.pop();
            }
            coordinate = stack.push(coordinate);
            coordinate = stack.push(coordinateArray[i]);
        }
        coordinate = stack.push(coordinateArray[0]);
        return stack;
    }

    private boolean isBetween(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        if (CGAlgorithms.computeOrientation(coordinate, coordinate2, coordinate3) != 0) {
            return false;
        }
        if (coordinate.x != coordinate3.x) {
            if (coordinate.x <= coordinate2.x && coordinate2.x <= coordinate3.x) {
                return true;
            }
            if (coordinate3.x <= coordinate2.x && coordinate2.x <= coordinate.x) {
                return true;
            }
        }
        if (coordinate.y != coordinate3.y) {
            if (coordinate.y <= coordinate2.y && coordinate2.y <= coordinate3.y) {
                return true;
            }
            if (coordinate3.y <= coordinate2.y && coordinate2.y <= coordinate.y) {
                return true;
            }
        }
        return false;
    }

    private Coordinate[] computeOctRing(Coordinate[] coordinateArray) {
        Coordinate[] coordinateArray2 = this.computeOctPts(coordinateArray);
        CoordinateList coordinateList = new CoordinateList();
        coordinateList.add(coordinateArray2, false);
        if (coordinateList.size() < 3) {
            return null;
        }
        coordinateList.closeRing();
        return coordinateList.toCoordinateArray();
    }

    private Coordinate[] computeOctPts(Coordinate[] coordinateArray) {
        int n;
        Coordinate[] coordinateArray2 = new Coordinate[8];
        for (n = 0; n < coordinateArray2.length; ++n) {
            coordinateArray2[n] = coordinateArray[0];
        }
        for (n = 1; n < coordinateArray.length; ++n) {
            if (coordinateArray[n].x < coordinateArray2[0].x) {
                coordinateArray2[0] = coordinateArray[n];
            }
            if (coordinateArray[n].x - coordinateArray[n].y < coordinateArray2[1].x - coordinateArray2[1].y) {
                coordinateArray2[1] = coordinateArray[n];
            }
            if (coordinateArray[n].y > coordinateArray2[2].y) {
                coordinateArray2[2] = coordinateArray[n];
            }
            if (coordinateArray[n].x + coordinateArray[n].y > coordinateArray2[3].x + coordinateArray2[3].y) {
                coordinateArray2[3] = coordinateArray[n];
            }
            if (coordinateArray[n].x > coordinateArray2[4].x) {
                coordinateArray2[4] = coordinateArray[n];
            }
            if (coordinateArray[n].x - coordinateArray[n].y > coordinateArray2[5].x - coordinateArray2[5].y) {
                coordinateArray2[5] = coordinateArray[n];
            }
            if (coordinateArray[n].y < coordinateArray2[6].y) {
                coordinateArray2[6] = coordinateArray[n];
            }
            if (!(coordinateArray[n].x + coordinateArray[n].y < coordinateArray2[7].x + coordinateArray2[7].y)) continue;
            coordinateArray2[7] = coordinateArray[n];
        }
        return coordinateArray2;
    }

    private Geometry lineOrPolygon(Coordinate[] coordinateArray) {
        if ((coordinateArray = this.cleanRing(coordinateArray)).length == 3) {
            return this.geomFactory.createLineString(new Coordinate[]{coordinateArray[0], coordinateArray[1]});
        }
        LinearRing linearRing = this.geomFactory.createLinearRing(coordinateArray);
        return this.geomFactory.createPolygon(linearRing, null);
    }

    private Coordinate[] cleanRing(Coordinate[] coordinateArray) {
        Assert.equals(coordinateArray[0], coordinateArray[coordinateArray.length - 1]);
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        Coordinate coordinate = null;
        for (int i = 0; i <= coordinateArray.length - 2; ++i) {
            Coordinate coordinate2 = coordinateArray[i];
            Coordinate coordinate3 = coordinateArray[i + 1];
            if (coordinate2.equals(coordinate3) || coordinate != null && this.isBetween(coordinate, coordinate2, coordinate3)) continue;
            arrayList.add(coordinate2);
            coordinate = coordinate2;
        }
        arrayList.add(coordinateArray[coordinateArray.length - 1]);
        Coordinate[] coordinateArray2 = new Coordinate[arrayList.size()];
        return arrayList.toArray(coordinateArray2);
    }

    private static class RadialComparator
    implements Comparator {
        private Coordinate origin;

        public RadialComparator(Coordinate coordinate) {
            this.origin = coordinate;
        }

        public int compare(Object object, Object object2) {
            Coordinate coordinate = (Coordinate)object;
            Coordinate coordinate2 = (Coordinate)object2;
            return RadialComparator.polarCompare(this.origin, coordinate, coordinate2);
        }

        private static int polarCompare(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
            double d = coordinate2.x - coordinate.x;
            double d2 = coordinate2.y - coordinate.y;
            double d3 = coordinate3.x - coordinate.x;
            double d4 = coordinate3.y - coordinate.y;
            int n = CGAlgorithms.computeOrientation(coordinate, coordinate2, coordinate3);
            if (n == 1) {
                return 1;
            }
            if (n == -1) {
                return -1;
            }
            double d5 = d * d + d2 * d2;
            double d6 = d3 * d3 + d4 * d4;
            if (d5 < d6) {
                return -1;
            }
            if (d5 > d6) {
                return 1;
            }
            return 0;
        }
    }
}

